% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_create.R
\name{make_explicit}
\alias{make_explicit}
\alias{create_explicit}
\title{Making networks with explicit ties}
\usage{
create_explicit(...)
}
\arguments{
\item{...}{Arguments passed on to \code{{igraph}}.}
}
\description{
This function creates a network from a vector of explicitly named nodes
and ties between them.
\code{create_explicit()} largely wraps \code{igraph::graph_from_literal()},
but will also accept character input and not just a formula,
and will never simplify the result.

Ties are indicated by \code{-}, and directed ties (arcs)
require \code{+} at either or both ends.
Ties are separated by commas, and isolates can be added as
an additional, unlinked node after the comma within the formula.
Sets of nodes can be linked to other sets of nodes through use of
a semi-colon.
See the example for a demonstration.
}
\examples{
  create_explicit(A -+ B, B -+ C, A +-+ C, D, E:F:G-+A, E:F+-+G:H)
}
\seealso{
Other makes: 
\code{\link{learning}},
\code{\link{make_create}},
\code{\link{make_generate}},
\code{\link{play}},
\code{\link{read}},
\code{\link{write}()}
}
\concept{makes}
