% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turf.R
\name{turf_center_of_mass}
\alias{turf_center_of_mass}
\title{Calculate center of mass}
\usage{
turf_center_of_mass(
  map,
  layer_id = NULL,
  data = NULL,
  coordinates = NULL,
  source_id,
  input_id = NULL
)
}
\arguments{
\item{map}{A mapboxgl, maplibre, mapboxgl_proxy, or maplibre_proxy object.}

\item{layer_id}{The ID of a layer or source (mutually exclusive with data and coordinates).}

\item{data}{An sf object (mutually exclusive with layer_id and coordinates).}

\item{coordinates}{A list of coordinate pairs list(c(lng,lat), c(lng,lat), ...) for multiple points (mutually exclusive with layer_id and data).}

\item{source_id}{The ID for the new source containing the center of mass points. Required.}

\item{input_id}{Optional. Character string specifying the Shiny input ID suffix for storing results. If NULL (default), no input is registered. For proxy operations, the result will be available as \code{input[[paste0(map_id, "_turf_", input_id)]]}.}
}
\value{
The map or proxy object for method chaining.
}
\description{
This function calculates the center of mass (geometric centroid) for each feature.
Uses turf.centerOfMass which provides more accurate centroids than turf.centroid,
matching the behavior of sf::st_centroid() and PostGIS ST_Centroid.
The result is added as a source to the map, which can then be styled using add_circle_layer(), etc.
}
