/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure;

import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.objects.OpenBitSet;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateLongVector;
import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.logging.Logger;

public class SBitSet2
implements IStateBitSet {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private final IEnvironment environment;
    private IStateLongVector words;
    private IStateInt wordsInUse;

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private void recalculateWordsInUse() {
        int i;
        for (i = this.wordsInUse.get() - 1; i >= 0 && this.words.get(i) == 0L; --i) {
        }
        this.wordsInUse.set(i + 1);
    }

    public SBitSet2(IEnvironment environment) {
        this.environment = environment;
        this.wordsInUse = environment.makeInt(0);
        this.initWords(64);
    }

    public SBitSet2(IEnvironment environment, int nbits) {
        this.environment = environment;
        this.wordsInUse = environment.makeInt(0);
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        this.initWords(nbits);
    }

    private void initWords(int nbits) {
        this.words = this.environment.makeLongVector(SBitSet2.wordIndex(nbits - 1) + 1, 0L);
    }

    public void ensureCapacity(int wordsRequired) {
        if (this.words.size() < wordsRequired) {
            int request = Math.max(2 * this.words.size(), wordsRequired);
            for (int i = 0; i < request - this.words.size(); ++i) {
                this.words.add(0L);
            }
        }
    }

    public DisposableIntIterator getCycleButIterator(int avoidIndex) {
        throw new UnsupportedOperationException();
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return SBitSet2.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    @Override
    public BitSet copyToBitSet() {
        BitSet view = new BitSet(this.size());
        int i = this.nextSetBit(0);
        while (i >= 0) {
            view.set(i, true);
            i = this.nextSetBit(i + 1);
        }
        return view;
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse.get() < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.wordsInUse.set(wordsRequired);
        }
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    @Override
    public void flip(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = SBitSet2.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        long tmp = this.words.quickGet(wordIndex);
        this.words.quickSet(wordIndex, tmp ^= 1L << bitIndex);
        this.recalculateWordsInUse();
    }

    @Override
    public void flip(int fromIndex, int toIndex) {
        SBitSet2.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = SBitSet2.wordIndex(fromIndex);
        int endWordIndex = SBitSet2.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            long tmp = this.words.quickGet(startWordIndex);
            this.words.quickSet(startWordIndex, tmp ^= firstWordMask & lastWordMask);
        } else {
            this.words.quickSet(startWordIndex, this.words.quickGet(startWordIndex) ^ firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words.set(i, this.words.quickGet(i) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.words.quickSet(endWordIndex, this.words.quickGet(endWordIndex) ^ lastWordMask);
        }
        this.recalculateWordsInUse();
    }

    @Override
    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = SBitSet2.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        this.words.quickSet(wordIndex, this.words.quickGet(wordIndex) | 1L << bitIndex);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        SBitSet2.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = SBitSet2.wordIndex(fromIndex);
        int endWordIndex = SBitSet2.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.words.quickSet(startWordIndex, this.words.quickGet(startWordIndex) | firstWordMask & lastWordMask);
        } else {
            this.words.quickSet(startWordIndex, this.words.quickGet(startWordIndex) | firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words.quickSet(i, -1L);
            }
            this.words.quickSet(endWordIndex, this.words.quickGet(endWordIndex) | lastWordMask);
        }
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    @Override
    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = SBitSet2.wordIndex(bitIndex);
        if (wordIndex >= this.wordsInUse.get()) {
            return;
        }
        this.words.quickSet(wordIndex, this.words.quickGet(wordIndex) & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL));
        this.recalculateWordsInUse();
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        SBitSet2.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = SBitSet2.wordIndex(fromIndex);
        if (startWordIndex >= this.wordsInUse.get()) {
            return;
        }
        int endWordIndex = SBitSet2.wordIndex(toIndex - 1);
        if (endWordIndex >= this.wordsInUse.get()) {
            toIndex = this.length();
            endWordIndex = this.wordsInUse.get() - 1;
        }
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.words.quickSet(startWordIndex, this.words.quickGet(startWordIndex) & (firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL));
        } else {
            this.words.quickSet(startWordIndex, this.words.quickGet(startWordIndex) & (firstWordMask ^ 0xFFFFFFFFFFFFFFFFL));
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words.quickSet(i, 0L);
            }
            this.words.quickSet(endWordIndex, this.words.quickGet(endWordIndex) & (lastWordMask ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.recalculateWordsInUse();
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.words.size(); ++i) {
            this.words.quickSet(i, 0L);
        }
    }

    @Override
    public final boolean get(int bitIndex) {
        int wordIndex = bitIndex >> 6;
        return wordIndex < this.wordsInUse.get() && (this.words.quickGet(wordIndex) & 1L << bitIndex) != 0L;
    }

    public SBitSet2 get(int fromIndex, int toIndex) {
        SBitSet2.checkRange(fromIndex, toIndex);
        int len = this.length();
        if (len <= fromIndex || fromIndex == toIndex) {
            return new SBitSet2(this.environment, 0);
        }
        if (toIndex > len) {
            toIndex = len;
        }
        SBitSet2 result = new SBitSet2(this.environment, toIndex - fromIndex);
        int targetWords = SBitSet2.wordIndex(toIndex - fromIndex - 1) + 1;
        int sourceIndex = SBitSet2.wordIndex(fromIndex);
        boolean wordAligned = (fromIndex & 0x3F) == 0;
        int i = 0;
        while (i < targetWords - 1) {
            result.words.quickSet(i, wordAligned ? this.words.quickGet(sourceIndex) : this.words.quickGet(sourceIndex) >>> fromIndex | this.words.quickGet(sourceIndex + 1) << -fromIndex);
            ++i;
            ++sourceIndex;
        }
        long lastWordMask = -1L >>> -toIndex;
        result.words.quickSet(targetWords - 1, (toIndex - 1 & 0x3F) < (fromIndex & 0x3F) ? this.words.quickGet(sourceIndex) >>> fromIndex | (this.words.quickGet(sourceIndex + 1) & lastWordMask) << -fromIndex : (this.words.quickGet(sourceIndex) & lastWordMask) >>> fromIndex);
        result.wordsInUse.set(targetWords);
        result.recalculateWordsInUse();
        return result;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        int u = SBitSet2.wordIndex(fromIndex);
        if (u >= this.wordsInUse.get()) {
            return -1;
        }
        long word = this.words.quickGet(u) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse.get()) {
                return -1;
            }
            word = this.words.quickGet(u);
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    @Override
    public int prevSetBit(int fromIndex) {
        int u = SBitSet2.wordIndex(fromIndex);
        if (u >= this.wordsInUse.get()) {
            return this.length() - 1;
        }
        long mask = -1L << fromIndex + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        long word = this.words.quickGet(u) & (mask != 0L ? mask : -1L);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words.quickGet(u);
        }
        return u * 64 + 63 - Long.numberOfLeadingZeros(word);
    }

    @Override
    public int prevClearBit(int fromIndex) {
        int u = SBitSet2.wordIndex(fromIndex);
        if (u >= this.wordsInUse.get()) {
            return fromIndex;
        }
        long mask = -1L << fromIndex + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        long word = (this.words.quickGet(u) ^ 0xFFFFFFFFFFFFFFFFL) & (mask != 0L ? mask : -1L);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words.quickGet(u) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + 63 - Long.numberOfLeadingZeros(word);
    }

    @Override
    public int capacity() {
        return this.words.size() * 64;
    }

    @Override
    public int nextClearBit(int fromIndex) {
        int u = SBitSet2.wordIndex(fromIndex);
        if (u >= this.wordsInUse.get()) {
            return fromIndex;
        }
        long word = (this.words.quickGet(u) ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse.get()) {
                return this.wordsInUse.get() * 64;
            }
            word = this.words.quickGet(u) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int length() {
        if (this.wordsInUse.get() == 0) {
            return 0;
        }
        return 64 * (this.wordsInUse.get() - 1) + (64 - Long.numberOfLeadingZeros(this.words.quickGet(this.wordsInUse.get() - 1)));
    }

    @Override
    public boolean isEmpty() {
        return this.wordsInUse.get() == 0;
    }

    public boolean intersects(SBitSet2 set) {
        for (int i = Math.min(this.wordsInUse.get(), set.wordsInUse.get()) - 1; i >= 0; --i) {
            if ((this.words.quickGet(i) & set.words.quickGet(i)) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(OpenBitSet set) {
        for (int i = Math.min(this.wordsInUse.get(), set.wordsInUse) - 1; i >= 0; --i) {
            if ((this.words.quickGet(i) & set.words[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public int cardinality() {
        int sum = 0;
        for (int i = 0; i < this.wordsInUse.get(); ++i) {
            sum += Long.bitCount(this.words.quickGet(i));
        }
        return sum;
    }

    @Override
    public void and(IStateBitSet setI) {
        SBitSet2 set = (SBitSet2)setI;
        if (this == set) {
            return;
        }
        while (this.wordsInUse.get() > set.wordsInUse.get()) {
            this.wordsInUse.add(-1);
            this.words.quickSet(this.wordsInUse.get(), 0L);
        }
        for (int i = 0; i < this.wordsInUse.get(); ++i) {
            this.words.quickSet(i, this.words.quickGet(i) & set.words.quickGet(i));
        }
        this.recalculateWordsInUse();
    }

    @Override
    public void or(IStateBitSet setI) {
        SBitSet2 set = (SBitSet2)setI;
        if (this == set) {
            return;
        }
        int wordsInCommon = Math.min(this.wordsInUse.get(), set.wordsInUse.get());
        if (this.wordsInUse.get() < set.wordsInUse.get()) {
            this.ensureCapacity(set.wordsInUse.get());
            this.wordsInUse.set(set.wordsInUse.get());
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            this.words.quickSet(i, this.words.quickGet(i) | set.words.quickGet(i));
        }
        if (wordsInCommon < set.wordsInUse.get()) {
            for (int idx = wordsInCommon; idx < this.wordsInUse.get(); ++idx) {
                this.words.quickSet(idx, set.words.quickGet(idx));
            }
        }
    }

    @Override
    public void xor(IStateBitSet setI) {
        SBitSet2 set = (SBitSet2)setI;
        int wordsInCommon = Math.min(this.wordsInUse.get(), set.wordsInUse.get());
        if (this.wordsInUse.get() < set.wordsInUse.get()) {
            this.ensureCapacity(set.wordsInUse.get());
            this.wordsInUse.set(set.wordsInUse.get());
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            this.words.quickSet(i, this.words.quickGet(i) ^ set.words.quickGet(i));
        }
        if (wordsInCommon < set.wordsInUse.get()) {
            for (int idx = wordsInCommon; idx < this.wordsInUse.get(); ++idx) {
                this.words.quickSet(idx, set.words.quickGet(idx));
            }
        }
        this.recalculateWordsInUse();
    }

    @Override
    public void andNot(IStateBitSet setI) {
        SBitSet2 set = (SBitSet2)setI;
        for (int i = Math.min(this.wordsInUse.get(), set.wordsInUse.get()) - 1; i >= 0; --i) {
            this.words.quickSet(i, this.words.quickGet(i) & (set.words.quickGet(i) ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.recalculateWordsInUse();
    }

    @Override
    public boolean intersects(IStateBitSet setI) {
        SBitSet2 set = (SBitSet2)setI;
        for (int i = Math.min(this.wordsInUse.get(), set.wordsInUse.get()) - 1; i >= 0; --i) {
            if ((this.words.quickGet(i) & set.words.quickGet(i)) == 0L) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.wordsInUse.get();
        while (--i >= 0) {
            h ^= this.words.quickGet(i) * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    @Override
    public int size() {
        return this.words.size() * 64;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SBitSet2)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        SBitSet2 set = (SBitSet2)obj;
        if (this.wordsInUse != set.wordsInUse) {
            return false;
        }
        for (int i = 0; i < this.wordsInUse.get(); ++i) {
            if (this.words.quickGet(i) == set.words.quickGet(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IStateBitSet copy() {
        SBitSet2 result = new SBitSet2(this.environment, this.size());
        result.wordsInUse.set(this.wordsInUse.get());
        for (int i = 0; i < this.wordsInUse.get(); ++i) {
            result.words.quickSet(i, this.words.quickGet(i));
        }
        return result;
    }

    public String toString() {
        int numBits = this.wordsInUse.get() > 128 ? this.cardinality() : this.wordsInUse.get() * 64;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            i = this.nextSetBit(i + 1);
            while (i >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i < endOfRun);
                i = this.nextSetBit(i + 1);
            }
        }
        b.append('}');
        return b.toString();
    }
}

