% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalue_data_chk.R
\name{metevalue.DMRfinder.chk}
\alias{metevalue.DMRfinder.chk}
\title{Check the DMRfinder data format}
\usage{
metevalue.DMRfinder.chk(
  input_filename_a,
  input_filename_b,
  sep = "\\t",
  bheader = FALSE
)
}
\arguments{
\item{input_filename_a}{the combined data of methylation rate file. This file is a sep (e.g. TAB) separated file with two key columns and several value columns in pairs:
For exampe:

chr    pos    g1    g1    g1    g1    g1    g1    g1    g1    g2    g2    g2    g2    g2    g2    g2    g2

chr and pos are keys;
g1 g1 g2 g2 must be stored in pairs.}

\item{input_filename_b}{the output file of DMRfinder.
The columns are (in order):

    - chr:   Chromosome

    - start: The position of the start sites of the corresponding region

    - end: The position of the end sites of the corresponding region

    - CpG: The number of CpG sites within the corresponding region

    - `Control:mu`: The absolute mean methylation level for the corresponding segment of the control group

    - `Exptl:mu`: The absolute mean methylation level for the corresponding segment of the experimental group

    - `Control->Exptl:diff`: The difference between the group means of methylation level

    - p: p-value}

\item{sep}{separator, default is the TAB key.}

\item{bheader}{a logical value indicating whether the input_filename_b file contains the names of the variables as its first line. By default, bheader = FALSE.}
}
\value{
list(file_a, file_b, file_a_b) returns a list with three pr-handled data.frames corresponding to the input_filename_a, input_filename_b file and a A JOIN B file.
}
\description{
Check the DMRfinder data format
}
\examples{
data("demo_DMRfinder_rate_combine")
data("demo_DMRfinder_DMRs")
}
