% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vartymetric.R
\name{vmetric.diag}
\alias{vmetric.diag}
\title{Metric-based threshold selection}
\usage{
vmetric.diag(
  xdat,
  thresh,
  B = 199L,
  type = c("qq", "pp"),
  dist = c("l1", "l2"),
  neval = 1000L,
  ci = 0.95
)
}
\arguments{
\item{xdat}{vector of observations}

\item{thresh}{vector of thresholds}

\item{B}{number of bootstrap replications}

\item{type}{string indicating scale, either \code{qq} for exponential quantile-quantile plot or \code{pp} for probability-probability plot (uniform)}

\item{dist}{string indicating norm, either \code{l1} for absolute error or \code{l2} for quadratic error}

\item{neval}{number of points at which to estimate the metric. Default to 1000L}

\item{ci}{level of symmetric confidence interval. Default to 0.95}
}
\value{
an invisible list with components
\itemize{
\item \code{thresh}: scalar threshold minimizing criterion
\item \code{cthresh}: vector of candidate thresholds
\item \code{metric}: value of the metric criterion evaluated at each threshold
\item \code{type}: argument \code{type}
\item \code{dist}: argument \code{dist}
}
}
\description{
Adaptation of Varty et al.'s metric-based threshold
automated diagnostic for the  independent and identically distributed case with no rounding.
}
\details{
The algorithm proceeds by first computing the maximum
likelihood algorithm and then simulating datasets from
replication with parameters drawn from a bivariate normal
approximation to the maximum likelihood estimator distribution.

For each bootstrap sample, we refit the
 model and convert the quantiles to
 exponential or uniform variates.
The mean absolute or mean squared distance
is calculated on these. The threshold
returned is the one with the lowest value
of the metric.
}
\references{
Varty, Z. and J.A. Tawn and P.M. Atkinson and S. Bierman (2021+), Inference for extreme earthquake magnitudes accounting for a time-varying measurement process
}
