% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mevr.R
\name{plot.mevr}
\alias{plot.mevr}
\title{Plot graphs of MEVD, SMEV or TMEV fit}
\usage{
\method{plot}{mevr}(
  x,
  q = c(2, 10, 20, 30, 50, 75, 100, 150, 200),
  ci = FALSE,
  type = c("all", "rl", "qq", "pp", "hist"),
  ...
)
}
\arguments{
\item{x}{An object of class\code{mevr}, whose \code{type} argument is one of MEVD, SMEV or TMEV}

\item{q}{vector of return periods, \eqn{q > 1}.}

\item{ci}{if \code{ci=TRUE}, confidence intervals will be computed.}

\item{type}{if omitted a panel with a return level plot (\code{type='rl'}, 
a density plot (\code{type='hist'}), a qq-plot (\code{type='qq'}) and a 
probability plot (\code{tpe='pp'}) are shown.}

\item{...}{Further parameters may also be supplied as arguments. 
See e.g. \link[base]{plot}.}
}
\value{
No return value, only a plot is produced.
}
\description{
A return level plot, qq-plot, pp-plot and a histogram with the fitted density is produced
}
\examples{
data(dailyrainfall)

# fit a simplified MEVD
fit <- fsmev(dailyrainfall)
fit
plot(fit)

# fit MEVD
fit <- fmev(dailyrainfall, method = "ls")
fit
plot(fit)
}
