% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mimi-internal.R
\name{irwls.cov}
\alias{irwls.cov}
\title{irwls.cov}
\usage{
irwls.cov(y, x, var.type, lambda1, lambda2, maxit = 100, alpha0 = NULL,
  theta0 = NULL, thresh = 1e-05, trace.it = F, max.rank = NULL,
  nu = 0.01)
}
\arguments{
\item{y}{nxp observation matrix}

\item{x}{(np)xN covariates matrix}

\item{var.type}{vector of size p indicating types of columns in y (gaussian, binary, poisson)}

\item{lambda1}{positive number, value of the nuclear norm regularization parameter}

\item{lambda2}{positive number, value of the l1 norm regularization parameter}

\item{maxit}{integer, maximum number of iterations}

\item{alpha0}{matrix of size (nb of groups)x(number of variables), initial value of the group effect, default 0}

\item{theta0}{matrix of size (nb of ind.)x(number of variables), initial value of the individual effect, default 0}

\item{thresh}{positive number, convergence criterion}

\item{trace.it}{boolean, if TRUE information about convergence will be displayes, default FALSE}

\item{max.rank}{integer, maximum rank of interaction matrix theta}

\item{nu}{positive number, backtracking line search parameter, default 0.01}
}
\value{
A list vith the following elements
\item{y.imputed}{the original data matrix where missing entries are imputed by their estimated means}
\item{param}{the estimated parameter matrix}
\item{alpha}{a (nb groups) x (nb variables) matrix containing the group effects}
\item{theta}{a (nb individuals) x (nb variables) matrix containing the individual effects}
}
\description{
irwls.cov
}
