% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mimi-internal.R
\name{irwls.lr}
\alias{irwls.lr}
\title{irwls.lr}
\usage{
irwls.lr(y, var.type, lambda1, maxit = 100, theta0 = NULL,
  thresh = 1e-05, trace.it = F, max.rank = NULL, nu = 0.1)
}
\arguments{
\item{y}{nxp observation matrix}

\item{var.type}{vector of size p indicating types of columns in y (gaussian, binary, poisson)}

\item{lambda1}{positive number, value of the nuclear norm regularization parameter}

\item{maxit}{integer, maximum number of iterations}

\item{theta0}{matrix of size (nb of ind.)x(number of variables), initial value of the individual effect, default 0}

\item{thresh}{positive number, convergence criterion}

\item{trace.it}{boolean, if TRUE information about convergence will be displayes, default FALSE}

\item{max.rank}{integer, maximum rank of interaction matrix theta}

\item{nu}{positive number, backtracking line search parameter, default 0.01}
}
\value{
A list vith the following elements
\item{y.imputed}{the imputed data set}
\item{theta}{estimated parameter matrix}
}
\description{
irwls.lr
}
