% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randef.R
\name{randef}
\alias{randef}
\title{Compute posterior estimates of random effect}
\usage{
randef(x, ndraws = 1000, thin = 10, return.draws = FALSE)
}
\arguments{
\item{x}{an estimated model object from the \code{\link{mixedmirt}} function}

\item{ndraws}{total number of draws to perform. Default is 1000}

\item{thin}{amount of thinning to apply. Default is to use every 10th draw}

\item{return.draws}{logical; return a list containing the thinned draws of the posterior?}
}
\description{
Stochastically compute random effects for \code{MixedClass} objects with Metropolis-Hastings
samplers and averaging over the draws to obtain expected a posteriori predictions.
Returns a list of the estimated effects.
}
\examples{
\dontrun{
# make an arbitrary groups
covdat <- data.frame(group = rep(paste0('group', 1:49), each=nrow(Science)/49))

# partial credit model
mod <- mixedmirt(Science, covdat, model=1, random = ~ 1|group)
summary(mod)

effects <- randef(mod, ndraws = 2000, thin = 20)
head(effects$Theta)
head(effects$group)

}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.

Chalmers, R. P. (2015). Extended Mixed-Effects Item Response Models with the MH-RM Algorithm.
\emph{Journal of Educational Measurement, 52}, 200-222. \doi{10.1111/jedm.12072}
\doi{10.18637/jss.v048.i06}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{effects}
\keyword{random}
