% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CnfUniverse.R
\name{CnfUniverse}
\alias{CnfUniverse}
\title{Symbol Table for CNF Formulas}
\usage{
CnfUniverse()
}
\value{
A new \code{CnfUniverse} object.
}
\description{
A symbol table for CNF formulas. The \code{CnfUniverse} is a by-reference object
that stores the domain of each symbol. Symbols are created with \code{\link[=CnfSymbol]{CnfSymbol()}}
and can be retrieved with \code{$}.
Using \code{[[} retrieves a given symbol's domain.

It is only possible to combine symbols from the same (identical) universe.

This is part of the CNF representation tooling, which is currently considered
experimental; it is for internal use.
}
\examples{
u = CnfUniverse()
X = CnfSymbol(u, "X", c("a", "b", "c"))
Y = CnfSymbol(u, "Y", c("d", "e", "f"))

u$X
u[["Y"]]

X \%among\% c("a", "c")
u$X \%among\% c("a", "c")
Y \%among\% c("d", "e", "f")
Y \%among\% character(0)

u$X \%among\% "a" | u$Y \%among\% "d"
}
\seealso{
Other CNF representation objects: 
\code{\link{CnfAtom}()},
\code{\link{CnfClause}()},
\code{\link{CnfFormula}()},
\code{\link{CnfSymbol}()}
}
\concept{CNF representation objects}
\keyword{internal}
