% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers.R
\name{mmrm_tidiers}
\alias{mmrm_tidiers}
\alias{tidy.mmrm}
\alias{glance.mmrm}
\alias{augment.mmrm}
\title{Tidying Methods for \code{mmrm} Objects}
\usage{
\method{tidy}{mmrm}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{glance}{mmrm}(x, ...)

\method{augment}{mmrm}(
  x,
  newdata = NULL,
  interval = c("none", "confidence", "prediction"),
  se_fit = (interval != "none"),
  type.residuals = c("response", "pearson", "normalized"),
  ...
)
}
\arguments{
\item{x}{(\code{mmrm})\cr fitted model.}

\item{conf.int}{(\code{flag})\cr if \code{TRUE} columns for the lower (\code{conf.low}) and upper bounds
(\code{conf.high}) of coefficient estimates are included.}

\item{conf.level}{(\code{number})\cr defines the range of the optional confidence internal.}

\item{...}{only used by \code{augment()} to pass arguments to the \code{\link[=predict.mmrm_tmb]{predict.mmrm_tmb()}} method.}

\item{newdata}{(\code{data.frame} or \code{NULL})\cr optional new data frame.}

\item{interval}{(\code{string})\cr type of interval calculation.}

\item{se_fit}{(\code{flag})\cr whether to return standard errors of fit.}

\item{type.residuals}{(\code{string})\cr passed on to \code{\link[=residuals.mmrm_tmb]{residuals.mmrm_tmb()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These methods tidy the estimates from an \code{mmrm} object into a
summary.
}
\section{Functions}{
\itemize{
\item \code{tidy(mmrm)}: derives tidy \code{tibble} from an \code{mmrm} object.

\item \code{glance(mmrm)}: derives \code{glance} \code{tibble} from an \code{mmrm} object.

\item \code{augment(mmrm)}: derives \code{augment} \code{tibble} from an \code{mmrm} object.

}}
\examples{
fit <- mmrm(
  formula = FEV1 ~ RACE + SEX + ARMCD * AVISIT + us(AVISIT | USUBJID),
  data = fev_data
)
# Applying tidy method to return summary table of covariate estimates.
fit |> tidy()
fit |> tidy(conf.int = TRUE, conf.level = 0.9)
# Applying glance method to return summary table of goodness of fit statistics.
fit |> glance()
# Applying augment method to return merged `tibble` of model data, fitted and residuals.
fit |> augment()
fit |> augment(interval = "confidence")
fit |> augment(type.residuals = "pearson")
}
\seealso{
\code{\link{mmrm_methods}}, \code{\link{mmrm_tmb_methods}} for additional methods.
}
