% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{mc_calc_snow}
\alias{mc_calc_snow}
\title{Snow detection from temperature}
\usage{
mc_calc_snow(
  data,
  sensor,
  output_sensor = "snow",
  localities = NULL,
  range = 1,
  tmax = 1.25,
  days = 3
)
}
\arguments{
\item{data}{cleaned myClim object see \link{myClim-package}}

\item{sensor}{name of temperature sensor used for snow estimation. (e.g. TMS_T2)}

\item{output_sensor}{name of output snow sensor (default "snow")}

\item{localities}{list of locality_ids where snow will be calculated; if NULL then all (default NULL)}

\item{range}{maximum temperature range threshold for snow-covered sensor (default 1°C)}

\item{tmax}{maximum temperature threshold for snow-covered sensor  (default 1.25°C)}

\item{days}{number of days to be used for moving-window for snow detection algorithm (default 3 days)}
}
\value{
myClim object with added virtual sensor 'snow' (logical) indicating snow presence/absence (TRUE/FALSE).
}
\description{
This function creates a new virtual sensor on locality within the myClim data object.
Virtual sensor hosts values of snow cover presence/absence detected from temperature time-series.
}
\details{
Function detects snow cover from temperature time-series. Temperature sensor is considered as covered by snow
when the maximal temperature in the preceding or subsequent time-window (specified by \code{days} param)
does not exceed specific \code{tmax} threshold value (default 1.25°C) and the temperature range remain below specified
\code{range} threshold (default 1°C). This function rely on insulating effect of a of snow layer,
significantly reducing diurnal temperature variation and restricting the maximal temperature near the ground
close to freezing point. Temperature sensor near the ground (\code{TMS_T2}) is default choice for snow-cover detection from Tomst TMS loggers.
Snow detection with default values accurately detects snow of depth > 15cm (unpublished data).
For detection of thin snow, range parameter should be set to 3-4 °C.
The function returns vector of snow cover (TRUE/FLASE) with same time-step as input data. To get number of days with snow cover
and more snow summary characteristics use \link{mc_calc_snow_agg} after snow detection.
}
\examples{
data <- mc_calc_snow(mc_data_example_agg, "TMS_T2", output_sensor="TMS_T2_snow",
                     localities = c("A2E32", "A6W79"))
}
