% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloset_sc.R
\name{.TXI_sc_adaptive}
\alias{.TXI_sc_adaptive}
\title{Adaptive TXI calculation for single cell expression}
\usage{
.TXI_sc_adaptive(expression, strata_values, force_method = NULL, ncores = NULL)
}
\arguments{
\item{expression}{Matrix of expression values, dgCMatrix}

\item{strata_values}{Numeric vector of phylostratum values}

\item{force_method}{Character, force specific method: "r", "cpp_simple", or "cpp_batched"}

\item{ncores}{Integer, number of cores to use (default: parallel::detectCores())}
}
\value{
Vector of TXI values
}
\description{
Automatically selects the best TXI implementation based on dataset size
and available computational resources. Uses R implementation for smaller datasets
and C++ implementation with optimal parallelization for larger datasets.
}
\details{
Based on performance benchmarking:
- R implementation is fastest for < 50,000 cells
- C++ batched implementation becomes advantageous for >= 100,000 cells
- Optimal core count scales with dataset size
}
\keyword{internal}
