% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{Ops.CFVariable}
\alias{Ops.CFVariable}
\alias{Math.CFVariable}
\title{Operations on CFVariable objects}
\usage{
\method{Ops}{CFVariable}(e1, e2)

\method{Math}{CFVariable}(x, ...)
}
\arguments{
\item{e1, e2}{\code{CFVariable} objects, or a single numeric value.}

\item{x}{A CFVariable object.}

\item{...}{Additional arguments passed on to the math functions.}
}
\value{
A new \code{CFVariable} object. The object will have the same coordinate
space as the \code{CFVariable} object used as argument. Arguments are not copied
and the new object will only have the "actual_range" attribute set.

Results that are logical (see the examples) are stored using the \code{NC_SHORT}
data type because netCDF does not have a native logical data type.
}
\description{
Basic arithmetic, mathematical and logical operations can be applied on the
data of \link{CFVariable} objects having a suitable data type, specifically the
base R functions from the Ops and Math groups of the S3 \link{groupGeneric}
functions.
}
\details{
The functions always return a new \code{CFVariable} object. Functions can thus be
concatenated to create more complex expressions. The data type of the new
object is determined by the base R function; its name is concatenated from
the names in the argument object(s).

For the Ops functions with two arguments, if both arguments are a
\code{CFVariable} object they have to be compatible: same shape, axis coordinate
values and coordinate reference system. The resulting \code{CFVariable} object
will use the same axes as the \code{CFVariable} object(s) used as argument.

The attributes of the resulting \code{CFVariable} object should be updated to
reflect its contents, in particular the "name", "long_name", "standard_name"
and "units" attributes. Attributes are not copied over from the \code{CFVariable}
objects in the arguments.
}
\examples{
fn <- system.file("extdata", "ERA5land_Rwanda_20160101.nc", package = "ncdfCF")
ds <- open_ncdf(fn)

# Temperature data in K
t2m <- ds[["t2m"]]

# Convert to degrees_Celsius
t2mC <- t2m - 273.15
t2mC$name <- "t2m_Celsius"
t2mC$set_attribute("units", "NC_CHAR", "degrees_Celsius")
t2mC

hot <- t2mC > 20
hot$name <- "t2m_Celsius_over_20"
hot$set_attribute("long_name", "NC_CHAR", "Flag to indicate where temperature is 20C or hotter")
hot$set_attribute("units", "NC_CHAR", "1")
hot

}
