% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-mcmc.R
\name{as_mcmc}
\alias{as_mcmc}
\alias{as_mcmc.mcmc.list}
\alias{as_mcmc.nlist}
\alias{as_mcmc.nlists}
\title{Coerce to mcmc Object}
\usage{
as_mcmc(x, ...)

\method{as_mcmc}{mcmc.list}(x, ...)

\method{as_mcmc}{nlist}(x, ...)

\method{as_mcmc}{nlists}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Unused.}
}
\value{
An mcmc object.
}
\description{
Coerce an R object to an mcmc object.
}
\section{Methods (by class)}{
\itemize{
\item \code{mcmc.list}: Coerce an mcmc.list object to an mcmc object.

\item \code{nlist}: Coerce an nlist object to an mcmc object.

\item \code{nlists}: Coerce an nlists object to an mcmc object.
}}

\examples{
as_mcmc(as_mcmc_list(nlists(nlist(x = 2), nlist(x = 3))))
as_mcmc(nlist(x = matrix(1:6, 2)))
as_mcmc(nlists(
  nlist(x = matrix(1:6, 2)),
  nlist(x = matrix(3:8, 2))
))
}
\seealso{
\code{\link[coda:mcmc]{coda::as.mcmc()}}

Other mcmc: 
\code{\link{as_mcmc_list}()}
}
\concept{mcmc}
