% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posthoc.R
\name{posthocControl}
\alias{posthocControl}
\title{Control options for the posthoc estimation method}
\usage{
posthocControl(sigdig = 3, ..., interaction = FALSE, maxOuterIterations = NULL)
}
\arguments{
\item{sigdig}{Optimization significant digits. This controls:

\itemize{

 \item The tolerance of the inner and outer optimization is \code{10^-sigdig}

 \item The tolerance of the ODE solvers is
 \code{0.5*10^(-sigdig-2)}; For the sensitivity equations and
 steady-state solutions the default is \code{0.5*10^(-sigdig-1.5)}
 (sensitivity changes only applicable for liblsoda)

 \item The tolerance of the boundary check is \code{5 * 10 ^ (-sigdig + 1)}

}}

\item{...}{Parameters used in the default `foceiConrol()`}

\item{interaction}{Interaction term for the model, in this case the
default is `FALSE`, though you can set it to be `TRUE` as well.}

\item{maxOuterIterations}{ignored, posthoc always sets this to 0.}
}
\value{
posthocControl object
}
\description{
This option is for simply getting the maximum a-prior (MAP) also
called the posthoc estimates
}
\examples{

posthocControl()
}
\author{
Matthew L. Fidler
}
