% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\docType{methods}
\name{dbGetPartition}
\alias{dbGetPartition}
\alias{dbGetPartition,AthenaConnection-method}
\title{Athena table partitions}
\usage{
dbGetPartition(conn, name, ...)

\S4method{dbGetPartition}{AthenaConnection}(conn, name, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{A character string specifying a DBMS table name.}

\item{...}{Other parameters passed on to methods.}
}
\value{
data.frame that returns all partitions in table, if no partitions in Athena table then
        function will return error from Athena.
}
\description{
This method returns all partitions from Athena table.
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `noctua::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(noctua::athena())
                 
# write iris table to Athena                  
dbWriteTable(con, "iris",
             iris,
             partition = c("timestamp" = format(Sys.Date(), "\%Y\%m\%d")),
             s3.location = "s3://path/to/store/athena/table/")

# return table partitions
noctua::dbGetPartition(con, "iris")

# disconnect from Athena
dbDisconnect(con)
}
}
