\name{deter.iso}
\alias{deter.iso}

\title{
Generating list of type iso from filtered m/z differences.
}
\description{
Produces a list of m/z differences from \code{diffs} output generated by \code{\link[nontarget]{plotdiff}} to be used as argument \code{iso} 
in \code{\link[nontarget]{pattern.search}}.
Thus, replaces the \code{iso} argument to \code{\link[nontarget]{pattern.search}} from \code{\link[nontarget]{make.isos}} and 
\code{\link[enviPat]{isotopes}} by another \code{iso} argument of the most frequent m/z differences detected among the HRMS peaks by \code{\link[nontarget]{plotdiff}}.
}
\usage{
deter.iso(diffs, histbreaks = 50000, mzmin = 0, mzmax = 0.5, 
cutcount = 180, plotit = TRUE)
}
\arguments{
  \item{diffs}{
	vector diffs, i.e. output of function \code{\link[nontarget]{plotdiff}}
	}
  \item{histbreaks}{
	Number of histogram breaks; thus defines the mztol window to be used with \code{\link[nontarget]{pattern.search}}, see details.
	}
  \item{mzmin}{
	Minimum value for m/z differences in resulting iso list.
	}
  \item{mzmax}{
	Maximum value for m/z differences in resulting iso list.
	}
  \item{cutcount}{
	Histogram classes with frequencies below cutcount will be excluded from iso
	}
  \item{plotit}{
	Should a plot of the sekected histogram classes be plotted? Recommended.
	}
}
\details{
In addition to returning a \code{iso} argument, prints argument values for \code{mztol}, \code{ppm} and \code{deter} 
of \code{\link[nontarget]{pattern.search}} when using iso from \code{\link[nontarget]{deter.iso}}.
Also see \code{deter} argument of \code{\link[nontarget]{pattern.search}}.
}
\value{

	List of type iso with 5 entries

	\item{iso[[1]]}{"list of isotopes".}
	\item{iso[[2]]}{"list of isotope masses".}
	\item{iso[[3]]}{"charges".}
	\item{iso[[4]]}{"number of isotope m/z".}
	\item{iso[[5]]}{"elements".}

}

\note{
Experimental. For more consistent results, use \code{\link[nontarget]{make.isos}} instead.
}

\author{
Martin Loos
}

\seealso{
	\code{\link[nontarget]{pattern.search}}
	\code{\link[nontarget]{plotdiff}}
	\code{\link[nontarget]{make.isos}}
}
\examples{
\donttest{
data(peaklist)
diffs<-plotdiff(peaklist, histbreaks = 10000, rttol = c(0, 0), mztol = c(0.3, 100), plotit = TRUE);
iso<-deter.iso(diffs,histbreaks=10000,mzmin=0,mzmax=40,cutcount=500,plotit=TRUE);
pattern<-pattern.search(
  peaklist,
  iso,
  cutint=10000,
  rttol=c(-0.05,0.05),
  mztol=0.005,
  mzfrac=0.1,
  ppm=FALSE,
  inttol=0.2,
  #rules=c(FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE),
  rules=c(TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE),
  deter=TRUE,
  entry=50
);
}
}

