% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalPolyRegMain.R
\name{LocalPolyRegMain}
\alias{LocalPolyRegMain}
\title{The main function of the (partial) local polynomial regression.}
\usage{
LocalPolyRegMain(
  Y,
  X,
  x_eval = NULL,
  degree = 2,
  deriv_ord = 1,
  h = NULL,
  b = NULL,
  kernT = "epanechnikov",
  kernS = "epanechnikov"
)
}
\arguments{
\item{Y}{The input n-dimensional outcome variable vector.}

\item{X}{The input n*(d+1) matrix. The first column of X stores the
treatment/exposure variables, while the other d columns are confounding variables.}

\item{x_eval}{The n*(d+1) matrix for evaluating the local polynomial regression
estimates. (Default: x_eval = NULL. Then, x_eval = \code{X}.)}

\item{degree}{Degree of local polynomials. (Default: degree = 2.)}

\item{deriv_ord}{The order of the estimated derivative of the conditional mean
outcome function. (Default: deriv_ord = 1.)}

\item{h, b}{The bandwidth parameters for the treatment/exposure variable
and confounding variables (Default: h = NULL, b = NULL. Then, the rule-of-thumb
bandwidth selector in Eq. (A1) of Yang and Tschernig (1999) is used with
additional scaling factors C_h and C_b, respectively.)}

\item{kernT, kernS}{The names of kernel functions for the treatment/exposure
variable and confounding variables. (Default: kernT = "epanechnikov",
kernS = "epanechnikov".)}
}
\value{
The estimated conditional mean outcome function or its partial
derivatives evaluated at points \code{x_eval}.
}
\description{
This function implements the main part of the (partial) local polynomial
regression for estimating the conditional mean outcome function and
its partial derivatives.
}
\references{
Zhang, Y., Chen, Y.-C., and Giessing, A. (2024)
\emph{Nonparametric Inference on Dose-Response Curves Without the Positivity Condition.}
\url{https://arxiv.org/abs/2405.09003}.

Fan, J. and Gijbels, I. (1996) \emph{Local Polynomial Modelling and its
Applications. Chapman & Hall/CRC.}
}
\author{
Yikun Zhang, \email{yikunzhang@foxmail.com}
}
\keyword{(partial)}
\keyword{function}
\keyword{local}
\keyword{main}
\keyword{of}
\keyword{polynomial}
\keyword{regression}
\keyword{the}
