% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_midterm_demand_data}
\alias{example_midterm_demand_data}
\title{Example Midterm Demand Data
This dataset contains the seasonal mid-term demand (the difference between the yearly average hourly electricity demand and the daily average hourly electricity demand)
for each day for France from 2017 until 2021.}
\format{
A data frame with 1,825 rows and 10 columns:
\describe{
\item{\code{country}}{The country, represented by the ISO2C country code (e.g., \code{FR} for France).}
\item{\code{date}}{The date of the mid-term demand measurement (in \code{YYYY-MM-DD} format).}
\item{\code{year}}{The year of the observation.}
\item{\code{month}}{The month of the observation.}
\item{\code{day}}{The day of the month for the observation.}
\item{\code{wday}}{The day of the week for the observation (where 1 represents Sunday and 7 represents Saturday).}
\item{\code{avg_hourly_demand}}{The average hourly electricity demand (in megawatts) for the day.}
\item{\code{seasonal_avg_hourly_demand}}{The seasonal average hourly demand (in megawatts) for the day.}
\item{\code{holiday}}{Indicates whether the day is a public holiday (\code{1} for holiday, \code{0} for non-holiday).}
\item{\code{example}}{A boolean indicator to mark this dataset as an example dataset.}
}
}
\source{
demand data: Transparency Platform of the European Network of
Transmission System Operators for Electricity (ENTSO-E, https://transparency.entsoe.eu/);
holidays: https://date.nager.at/api/v3/publicholidays/
}
\usage{
example_midterm_demand_data
}
\description{
Example Midterm Demand Data
This dataset contains the seasonal mid-term demand (the difference between the yearly average hourly electricity demand and the daily average hourly electricity demand)
for each day for France from 2017 until 2021.
}
\keyword{dataset}
\keyword{midterm-demand}
\keyword{weather-variables}
