% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oXim-main.R
\name{createFilterSetting}
\alias{createFilterSetting}
\title{Create filter-settings Object.}
\usage{
createFilterSetting(name = "default", type = NULL, radius = NULL,
  times = NULL, tolerance = NULL)
}
\arguments{
\item{name}{Parameter to indicate prefixed profile of settings. This parameter has priority over the others.}

\item{type}{Indicates type of filter to use. See details below.}

\item{radius}{Indicates the size (on pixels) of sides of square used to apply the filters.}

\item{times}{Indicates number of times to apply the filters.}

\item{tolerance}{For \code{.noiselessFilter}, this parameter indicates proportion of pixels to consider from
filter matrix (radius x radius).}
}
\description{
This function allows to create correctly a filter-settings object in order to insert as input on
\code{getOxyrange} function.
}
\details{
About each parameter:
\describe{
\item{\strong{name}}{This parameter must be a string and it works as a short way to select an specific set of filter
settings. (It will be fully available in next version.)}
\item{\strong{type}}{This parameter must be a string and indicates what kind of filter method will be applied to the
echigrams. There are two options to select: \code{.definerFilter} which works as a reverse-effect median filter
and \code{.noiselessFilter} which removes  noisy signals on the echograms.}
\item{\strong{radius}}{This parameter is useful to specify the size of the filter matrix which will be applied to
the echogram. It must be integer, even and greater than 3.}
\item{\strong{times}}{This parameter is useful to indicate how many times the filter will be applied to the echogram.
It must be integer and greater than 1. The function will remove rows with \code{times=0} values.}
\item{\strong{tolerance}}{Internal parameter to modify selected values on a convolution matrix filter. This parameter
is meaningful only for \code{.noiselessFilter}.}
}
}
\examples{
# Use default profile
createFilterSetting(name = "default")

# Generate a personalized profile
createFilterSetting(type = ".definerFilter", radius = c(3, 5, 5))
}

