% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{set_api_key}
\alias{set_api_key}
\title{Set OMOPHub API Key}
\usage{
set_api_key(key, store = c("env", "keyring"))
}
\arguments{
\item{key}{The API key to store.}

\item{store}{Where to store the key. One of:
\itemize{
\item \code{"env"}: Set as environment variable for current session (default)
\item \code{"keyring"}: Store securely in system keyring (requires \code{keyring} package)
}}
}
\value{
Invisibly returns \code{TRUE} on success.
}
\description{
Stores the OMOPHub API key in the specified location.
}
\examples{
\dontrun{
# Store in environment (current session only)
set_api_key("your_api_key")

# Store securely in keyring (persistent)
set_api_key("your_api_key", store = "keyring")
}
}
