% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_class.R
\name{new_class}
\alias{new_class}
\title{Add a new valid class to an ontology}
\usage{
new_class(new, target, description = NULL, ontology = NULL)
}
\arguments{
\item{new}{\code{\link[=character]{character(1)}}\cr the new class label.}

\item{target}{\code{\link[=character]{character(1)}}\cr the class to which the new class
shall be related.}

\item{description}{\code{\link[=character]{character(1)}}\cr a verbatim description of
the new class.}

\item{ontology}{\code{\link[=list]{ontology(1)}}\cr either a path where the ontology is
stored, or an already loaded ontology.}
}
\value{
the updated ontology that contains the new class(es) defined here.
}
\description{
Add a new valid class to an ontology
}
\examples{
ontoDir <- system.file("extdata", "crops.rds", package = "ontologics")
onto <- load_ontology(path = ontoDir)

onto <- new_class(new = "use type", target = "class", description = "something",
                  ontology = onto)

}
