% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.R
\name{dsadmin.log}
\alias{dsadmin.log}
\title{Get DataSHIELD logs}
\usage{
dsadmin.log(opal, all = TRUE)
}
\arguments{
\item{opal}{Opal connection object.}

\item{all}{Get all or only latest log messages.}
}
\description{
The DataSHIELD log is structured as follows:
}
\details{
\strong{Common fields}
\itemize{
  \item timestamp: when action is logged
  \item version: not used
  \item message: human readable message
  \item logger_name: name of the log channel
  \item thread_name: java thread name
  \item level: log level (TRACE, DEBUG, INFO, WARN, ERROR)
  \item level_value: log level numeric value
  \item ip: ip origin of the request, when available
  \item ds_id: unique DS session ID
  \item ds_profile: DS profile name (available after the R server session is created, can be after authentication)
  \item username: DS user name
  \item r_duration: time spent by the remote R server action (all except PARSE)
  \item r_size: R result serialized object size in bytes
  \item ds_action: DS operation (OPEN, CLOSE, PARSE, ASSIGN, AGGREGATE, LS, RM, WS_SAVE, WS_RESTORE)
}

\strong{DS operations fields}
\itemize{
  \item OPEN: DS session opened (note: happens after successful authentication as R server session creation is deferred)
  \item CLOSE: DS session closed
  \item PARSE: R expression parsed
  \itemize{
    \item ds_map: DS function mappings used in the R parser, separated by semicolons when several functions are called
    \item ds_script_in: R script as sent by DS user
    \item ds_script_out: R script rewritten by opal, to be evaluated
  }
  \item ASSIGN:
  \itemize{
    \item ds_symbol: assigned symbol name
    \item ds_table: table name that is assigned
    \item ds_resource: resource name that is assigned
    \item ds_eval: assign R expression that is evaluated
  }
  \item AGGREGATE:
  \itemize{
    \item ds_eval: aggregate R expression that is evaluated
  }
  \item LS: R symbols listed
  \item RM: R symbol removed
  \itemize{
    \item ds_symbol: symbol name to remove
  }
  \item WS_SAVE:
  \itemize{
    \item ds_ws: workspace name
  }
  \item WS_RESTORE:
  \itemize{
    \item ds_ws: workspace name
  }
}
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
dsadmin.log(o)
opal.logout(o)
}
}
