% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.task.R
\name{opal.task_wait}
\alias{opal.task_wait}
\title{Wait for a task to complete.}
\usage{
opal.task_wait(opal, id, max = NULL)
}
\arguments{
\item{opal}{Opal object.}

\item{id}{Task identifier.}

\item{max}{Maximum time (in seconds) to wait for the task completion. Default is NULL (no maximum).}
}
\description{
The task completion is defined by its status: *SUCCEEDED*, *FAILED* or *CANCELED*.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.task_wait(o, '1')
opal.logout(o)
}
}
\seealso{
Other task functions: 
\code{\link{opal.task}()},
\code{\link{opal.task_cancel}()},
\code{\link{opal.tasks}()}
}
\concept{task functions}
