% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-chart-sheet.R
\name{wbChartSheet}
\alias{wbChartSheet}
\title{R6 class for a Workbook Chart Sheet}
\value{
A character vector of xml
}
\description{
A chart sheet
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{sheetPr}}{Sheet something?}

\item{\code{sheetViews}}{Something}

\item{\code{sheetProtection}}{sheetProtection}

\item{\code{customSheetViews}}{customSheetViews}

\item{\code{pageMargins}}{page margins}

\item{\code{pageSetup}}{pageSetup}

\item{\code{headerFooter}}{headerFooter}

\item{\code{drawing}}{drawing}

\item{\code{drawingHF}}{drawingHF}

\item{\code{picture}}{picture}

\item{\code{webPublishItems}}{webPublishItems
#' @field hyperlinks hyperlinks
hyperlinks = NULL,}

\item{\code{relships}}{relships}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-wbChartSheet-new}{\code{wbChartSheet$new()}}
\item \href{#method-wbChartSheet-get_prior_sheet_data}{\code{wbChartSheet$get_prior_sheet_data()}}
\item \href{#method-wbChartSheet-set_sheetview}{\code{wbChartSheet$set_sheetview()}}
\item \href{#method-wbChartSheet-clone}{\code{wbChartSheet$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbChartSheet-new"></a>}}
\if{latex}{\out{\hypertarget{method-wbChartSheet-new}{}}}
\subsection{Method \code{new()}}{
Create a new workbook chart sheet object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbChartSheet$new(tabColor = tabColor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tabColor}}{\code{character} a tab color to set}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbChartSheet} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbChartSheet-get_prior_sheet_data"></a>}}
\if{latex}{\out{\hypertarget{method-wbChartSheet-get_prior_sheet_data}{}}}
\subsection{Method \code{get_prior_sheet_data()}}{
get (prior) sheet data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbChartSheet$get_prior_sheet_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbChartSheet-set_sheetview"></a>}}
\if{latex}{\out{\hypertarget{method-wbChartSheet-set_sheetview}{}}}
\subsection{Method \code{set_sheetview()}}{
add sheetview
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbChartSheet$set_sheetview(
  color_id = NULL,
  default_grid_color = NULL,
  right_to_left = NULL,
  show_formulas = NULL,
  show_grid_lines = NULL,
  show_outline_symbols = NULL,
  show_row_col_headers = NULL,
  show_ruler = NULL,
  show_white_space = NULL,
  show_zeros = NULL,
  tab_selected = NULL,
  top_left_cell = NULL,
  view = NULL,
  window_protection = NULL,
  workbook_view_id = NULL,
  zoom_scale = NULL,
  zoom_scale_normal = NULL,
  zoom_scale_page_layout_view = NULL,
  zoom_scale_sheet_layout_view = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_id, default_grid_color}}{Integer: A color, default is 64}

\item{\code{right_to_left}}{Logical: if TRUE column ordering is right  to left}

\item{\code{show_formulas}}{Logical: if TRUE cell formulas are shown}

\item{\code{show_grid_lines}}{Logical: if TRUE the worksheet grid is shown}

\item{\code{show_outline_symbols}}{Logical: if TRUE outline symbols are shown}

\item{\code{show_row_col_headers}}{Logical: if TRUE row and column headers are shown}

\item{\code{show_ruler}}{Logical: if TRUE a ruler is shown in page layout view}

\item{\code{show_white_space}}{Logical: if TRUE margins are shown in page layout view}

\item{\code{show_zeros}}{Logical: if FALSE cells containing zero are shown blank if !showFormulas}

\item{\code{tab_selected}}{Integer: zero vector indicating the selected tab}

\item{\code{top_left_cell}}{Cell: the cell shown in the top left corner / or top right with rightToLeft}

\item{\code{view}}{View: "normal", "pageBreakPreview" or "pageLayout"}

\item{\code{window_protection}}{Logical: if TRUE the panes are protected}

\item{\code{workbook_view_id}}{integer: Pointing to some other view inside the workbook}

\item{\code{zoom_scale, zoom_scale_normal, zoom_scale_page_layout_view, zoom_scale_sheet_layout_view}}{Integer: the zoom scale should be between 10 and 400. These are values for current, normal etc.}

\item{\code{...}}{additional arguments}

\item{\code{sheet}}{sheet}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbChartSheet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-wbChartSheet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbChartSheet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
