% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_cell_style}
\alias{wb_add_cell_style}
\title{add cell style for cell region}
\usage{
wb_add_cell_style(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  apply_alignment = NULL,
  apply_border = NULL,
  apply_fill = NULL,
  apply_font = NULL,
  apply_number_format = NULL,
  apply_protection = NULL,
  border_id = NULL,
  ext_lst = NULL,
  fill_id = NULL,
  font_id = NULL,
  hidden = NULL,
  horizontal = NULL,
  indent = NULL,
  justify_last_line = NULL,
  locked = NULL,
  num_fmt_id = NULL,
  pivot_button = NULL,
  quote_prefix = NULL,
  reading_order = NULL,
  relative_indent = NULL,
  shrink_to_fit = NULL,
  text_rotation = NULL,
  vertical = NULL,
  wrap_text = NULL,
  xf_id = NULL,
  ...
)
}
\arguments{
\item{wb}{a workbook}

\item{sheet}{the worksheet}

\item{dims}{the cell range}

\item{apply_alignment}{logical apply alignment}

\item{apply_border}{logical apply border}

\item{apply_fill}{logical apply fill}

\item{apply_font}{logical apply font}

\item{apply_number_format}{logical apply number format}

\item{apply_protection}{logical apply protection}

\item{border_id}{border ID to apply}

\item{ext_lst}{extension list something like \verb{<extLst>...</extLst>}}

\item{fill_id}{fill ID to apply}

\item{font_id}{font ID to apply}

\item{hidden}{logical cell is hidden}

\item{horizontal}{align content horizontal ('left', 'center', 'right')}

\item{indent}{logical indent content}

\item{justify_last_line}{logical justify last line}

\item{locked}{logical cell is locked}

\item{num_fmt_id}{number format ID to apply}

\item{pivot_button}{unknown}

\item{quote_prefix}{unknown}

\item{reading_order}{reading order left to right}

\item{relative_indent}{relative indentation}

\item{shrink_to_fit}{logical shrink to fit}

\item{text_rotation}{degrees of text rotation}

\item{vertical}{vertical alignment of content ('top', 'center', 'bottom')}

\item{wrap_text}{wrap text in cell}

\item{xf_id}{xf ID to apply}

\item{...}{additional arguments}
}
\value{
The \code{wbWorksheetObject}, invisibly
}
\description{
add cell style for cell region
}
\examples{
 wb <-
   wb_workbook() \%>\%
   wb_add_worksheet("S1") \%>\%
   wb_add_data("S1", mtcars)

 wb \%>\%
   wb_add_cell_style(
     "S1",
     "A1:K1",
     textRotation = "45",
     horizontal = "center",
     vertical = "center",
     wrapText = "1"
   )
}
\seealso{
Other styles: 
\code{\link{wb_add_border}()},
\code{\link{wb_add_fill}()},
\code{\link{wb_add_font}()},
\code{\link{wb_add_numfmt}()},
\code{\link{wb_clone_sheet_style}()}
}
\concept{styles}
