% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feasible.R
\name{caliperSize}
\alias{caliperSize}
\title{(Internal) Determines how many other units fall within a caliper distance}
\usage{
caliperSize(scores, z, width, structure = NULL)
}
\arguments{
\item{scores}{A numeric vector of scores providing 1-D position of units}

\item{z}{Treatment indicator vector}

\item{width}{Width of caliper, must be positive}

\item{structure}{Grouping factor to use in computation}
}
\value{
numeric Total number of pairwise distances remaining after the caliper is placed.
}
\description{
The matching functions \code{\link{fullmatch}} and \code{\link{pairmatch}}
have a maximum problem size, based on the number of comparisons between treated
and control units. For a completely dense problem, in which every treated units
is compared to every control unit there are \code{length(treated) *
length(control)} comparisons. A caliper restricts which comparisons are valid,
disallowing matches of treated and control pairs that are too far apart. A
caliper can significantly decrease the size of a matching problem. The
\code{caliperSize} function reports exactly who many valid treated-control
comparisons remain after applying a caliper of the given width.
}

