% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_up-parse_columns.R
\name{parse_columns}
\alias{parse_columns}
\title{Apply functions to columns.}
\usage{
parse_columns(data, functions_)
}
\arguments{
\item{data}{data frame}

\item{functions_}{named list where keys correspond to column names}
}
\value{
updated data frame
}
\description{
Apply functions to columns.
}
\examples{
\dontrun{
   parse_dt <- function(x){as.POSIXct(x, origin = "1970-01-01")}
   forecast <- get_forecast("Kassel")$list
   forecast \%<>\% parse_columns(list(dt = parse_dt))
}
}
