% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_savings_plans_purchase_recommendation}
\alias{costexplorer_get_savings_plans_purchase_recommendation}
\title{Retrieves your request parameters, Savings Plan Recommendations Summary
and Details}
\usage{
costexplorer_get_savings_plans_purchase_recommendation(
  SavingsPlansType,
  TermInYears,
  PaymentOption,
  AccountScope = NULL,
  NextPageToken = NULL,
  PageSize = NULL,
  LookbackPeriodInDays,
  Filter = NULL
)
}
\arguments{
\item{SavingsPlansType}{[required] The Savings Plans recommendation type that's requested.}

\item{TermInYears}{[required] The savings plan recommendation term that's used to generate these
recommendations.}

\item{PaymentOption}{[required] The payment option that's used to generate these recommendations.}

\item{AccountScope}{The account scope that you want your recommendations for. Amazon Web
Services calculates recommendations including the management account and
member accounts if the value is set to \code{PAYER}. If the value is
\code{LINKED}, recommendations are calculated for individual member accounts
only.}

\item{NextPageToken}{The token to retrieve the next set of results. Amazon Web Services
provides the token when the response from a previous call has more
results than the maximum page size.}

\item{PageSize}{The number of recommendations that you want returned in a single
response object.}

\item{LookbackPeriodInDays}{[required] The lookback period that's used to generate the recommendation.}

\item{Filter}{You can filter your recommendations by Account ID with the
\code{LINKED_ACCOUNT} dimension. To filter your recommendations by Account
ID, specify \code{Key} as \code{LINKED_ACCOUNT} and \code{Value} as the comma-separated
Acount ID(s) that you want to see Savings Plans purchase recommendations
for.

For GetSavingsPlansPurchaseRecommendation, the \code{Filter} doesn't include
\code{CostCategories} or \code{Tags}. It only includes \code{Dimensions}. With
\code{Dimensions}, \code{Key} must be \code{LINKED_ACCOUNT} and \code{Value} can be a single
Account ID or multiple comma-separated Account IDs that you want to see
Savings Plans Purchase Recommendations for. \code{AND} and \code{OR} operators are
not supported.}
}
\description{
Retrieves your request parameters, Savings Plan Recommendations Summary and Details.

See \url{https://paws-r.github.io/docs/costexplorer/get_savings_plans_purchase_recommendation.html} for full documentation.
}
\keyword{internal}
