% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud9_operations.R
\name{cloud9_create_environment_ec2}
\alias{cloud9_create_environment_ec2}
\title{Creates an Cloud9 development environment, launches an Amazon Elastic
Compute Cloud (Amazon EC2) instance, and then connects from the instance
to the environment}
\usage{
cloud9_create_environment_ec2(
  name,
  description = NULL,
  clientRequestToken = NULL,
  instanceType,
  subnetId = NULL,
  imageId,
  automaticStopTimeMinutes = NULL,
  ownerArn = NULL,
  tags = NULL,
  connectionType = NULL,
  dryRun = NULL
)
}
\arguments{
\item{name}{[required] The name of the environment to create.

This name is visible to other IAM users in the same Amazon Web Services
account.}

\item{description}{The description of the environment to create.}

\item{clientRequestToken}{A unique, case-sensitive string that helps Cloud9 to ensure this
operation completes no more than one time.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Client Tokens}
in the \emph{Amazon EC2 API Reference}.}

\item{instanceType}{[required] The type of instance to connect to the environment (for example,
\code{t2.micro}).}

\item{subnetId}{The ID of the subnet in Amazon VPC that Cloud9 will use to communicate
with the Amazon EC2 instance.}

\item{imageId}{[required] The identifier for the Amazon Machine Image (AMI) that's used to create
the EC2 instance. To choose an AMI for the instance, you must specify a
valid AMI alias or a valid Amazon EC2 Systems Manager (SSM) path.

From December 04, 2023, you will be required to include the \code{imageId}
parameter for the
\code{\link[=cloud9_create_environment_ec2]{create_environment_ec2}} action. This
change will be reflected across all direct methods of communicating with
the API, such as Amazon Web Services SDK, Amazon Web Services CLI and
Amazon Web Services CloudFormation. This change will only affect direct
API consumers, and not Cloud9 console users.

From January 22, 2024, Amazon Linux (AL1) will be removed from the list
of available image IDs for Cloud9. This is necessary as AL1 will reach
the end of maintenance support in December 2023, and as a result will no
longer receive security updates. We recommend using Amazon Linux 2023 as
the AMI to create your environment as it is fully supported. This change
will only affect direct API consumers, and not Cloud9 console users.

Since Ubuntu 18.04 has ended standard support as of May 31, 2023, we
recommend you choose Ubuntu 22.04.

\strong{AMI aliases}
\itemize{
\item Amazon Linux: \code{amazonlinux-1-x86_64}
\item Amazon Linux 2: \code{amazonlinux-2-x86_64}
\item Amazon Linux 2023 (recommended): \code{amazonlinux-2023-x86_64}
\item Ubuntu 18.04: \code{ubuntu-18.04-x86_64}
\item Ubuntu 22.04: \code{ubuntu-22.04-x86_64}
}

\strong{SSM paths}
\itemize{
\item Amazon Linux:
\verb{resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64}
\item Amazon Linux 2:
\verb{resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64}
\item Amazon Linux 2023 (recommended):
\verb{resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2023-x86_64}
\item Ubuntu 18.04:
\verb{resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64}
\item Ubuntu 22.04:
\verb{resolve:ssm:/aws/service/cloud9/amis/ubuntu-22.04-x86_64}
}}

\item{automaticStopTimeMinutes}{The number of minutes until the running instance is shut down after the
environment has last been used.}

\item{ownerArn}{The Amazon Resource Name (ARN) of the environment owner. This ARN can be
the ARN of any IAM principal. If this value is not specified, the ARN
defaults to this environment's creator.}

\item{tags}{An array of key-value pairs that will be associated with the new Cloud9
development environment.}

\item{connectionType}{The connection type used for connecting to an Amazon EC2 environment.
Valid values are \code{CONNECT_SSH} (default) and \code{CONNECT_SSM} (connected
through Amazon EC2 Systems Manager).

For more information, see \href{https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html}{Accessing no-ingress EC2 instances with Amazon EC2 Systems Manager}
in the \emph{Cloud9 User Guide}.}

\item{dryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and then connects from the instance to the environment.

See \url{https://www.paws-r-sdk.com/docs/cloud9_create_environment_ec2/} for full documentation.
}
\keyword{internal}
