% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nimblestudio_operations.R
\name{nimblestudio_create_studio}
\alias{nimblestudio_create_studio}
\title{Create a new studio}
\usage{
nimblestudio_create_studio(
  adminRoleArn,
  clientToken = NULL,
  displayName,
  studioEncryptionConfiguration = NULL,
  studioName,
  tags = NULL,
  userRoleArn
)
}
\arguments{
\item{adminRoleArn}{[required] The IAM role that studio admins will assume when logging in to the
Nimble Studio portal.}

\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If you don’t specify a client token, the
Amazon Web Services SDK automatically generates a client token and uses
it for the request to ensure idempotency.}

\item{displayName}{[required] A friendly name for the studio.}

\item{studioEncryptionConfiguration}{The studio encryption configuration.}

\item{studioName}{[required] The studio name that is used in the URL of the Nimble Studio portal when
accessed by Nimble Studio users.}

\item{tags}{A collection of labels, in the form of key-value pairs, that apply to
this resource.}

\item{userRoleArn}{[required] The IAM role that studio users will assume when logging in to the Nimble
Studio portal.}
}
\description{
Create a new studio.

See \url{https://www.paws-r-sdk.com/docs/nimblestudio_create_studio/} for full documentation.
}
\keyword{internal}
