% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_create_mobile_device_access_rule}
\alias{workmail_create_mobile_device_access_rule}
\title{Creates a new mobile device access rule for the specified WorkMail
organization}
\usage{
workmail_create_mobile_device_access_rule(
  OrganizationId,
  ClientToken = NULL,
  Name,
  Description = NULL,
  Effect,
  DeviceTypes = NULL,
  NotDeviceTypes = NULL,
  DeviceModels = NULL,
  NotDeviceModels = NULL,
  DeviceOperatingSystems = NULL,
  NotDeviceOperatingSystems = NULL,
  DeviceUserAgents = NULL,
  NotDeviceUserAgents = NULL
)
}
\arguments{
\item{OrganizationId}{[required] The WorkMail organization under which the rule will be created.}

\item{ClientToken}{The idempotency token for the client request.}

\item{Name}{[required] The rule name.}

\item{Description}{The rule description.}

\item{Effect}{[required] The effect of the rule when it matches. Allowed values are \code{ALLOW} or
\code{DENY}.}

\item{DeviceTypes}{Device types that the rule will match.}

\item{NotDeviceTypes}{Device types that the rule \strong{will not} match. All other device types
will match.}

\item{DeviceModels}{Device models that the rule will match.}

\item{NotDeviceModels}{Device models that the rule \strong{will not} match. All other device models
will match.}

\item{DeviceOperatingSystems}{Device operating systems that the rule will match.}

\item{NotDeviceOperatingSystems}{Device operating systems that the rule \strong{will not} match. All other
device operating systems will match.}

\item{DeviceUserAgents}{Device user agents that the rule will match.}

\item{NotDeviceUserAgents}{Device user agents that the rule \strong{will not} match. All other device
user agents will match.}
}
\description{
Creates a new mobile device access rule for the specified WorkMail organization.

See \url{https://www.paws-r-sdk.com/docs/workmail_create_mobile_device_access_rule/} for full documentation.
}
\keyword{internal}
