% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_list_mobile_device_access_overrides}
\alias{workmail_list_mobile_device_access_overrides}
\title{Lists all the mobile device access overrides for any given combination
of WorkMail organization, user, or device}
\usage{
workmail_list_mobile_device_access_overrides(
  OrganizationId,
  UserId = NULL,
  DeviceId = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{OrganizationId}{[required] The WorkMail organization under which to list mobile device access
overrides.}

\item{UserId}{The WorkMail user under which you list the mobile device access
overrides. Accepts the following types of user identities:
\itemize{
\item User ID: \code{12345678-1234-1234-1234-123456789012} or
\code{S-1-1-12-1234567890-123456789-123456789-1234}
\item Email address: \code{user@domain.tld}
\item User name: \code{user}
}}

\item{DeviceId}{The mobile device to which the access override applies.}

\item{NextToken}{The token to use to retrieve the next page of results. The first call
does not require a token.}

\item{MaxResults}{The maximum number of results to return in a single call.}
}
\description{
Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.

See \url{https://www.paws-r-sdk.com/docs/workmail_list_mobile_device_access_overrides/} for full documentation.
}
\keyword{internal}
