% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspacesweb_operations.R
\name{workspacesweb_create_network_settings}
\alias{workspacesweb_create_network_settings}
\title{Creates a network settings resource that can be associated with a web
portal}
\usage{
workspacesweb_create_network_settings(
  clientToken = NULL,
  securityGroupIds,
  subnetIds,
  tags = NULL,
  vpcId
)
}
\arguments{
\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Idempotency ensures that an API request
completes only once. With an idempotent request, if the original request
completes successfully, subsequent retries with the same client token
returns the result from the original successful request.

If you do not specify a client token, one is automatically generated by
the AWS SDK.}

\item{securityGroupIds}{[required] One or more security groups used to control access from streaming
instances to your VPC.}

\item{subnetIds}{[required] The subnets in which network interfaces are created to connect streaming
instances to your VPC. At least two of these subnets must be in
different availability zones.}

\item{tags}{The tags to add to the network settings resource. A tag is a key-value
pair.}

\item{vpcId}{[required] The VPC that streaming instances will connect to.}
}
\description{
Creates a network settings resource that can be associated with a web portal. Once associated with a web portal, network settings define how streaming instances will connect with your specified VPC.

See \url{https://www.paws-r-sdk.com/docs/workspacesweb_create_network_settings/} for full documentation.
}
\keyword{internal}
