% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspacesweb_operations.R
\name{workspacesweb_create_portal}
\alias{workspacesweb_create_portal}
\title{Creates a web portal}
\usage{
workspacesweb_create_portal(
  additionalEncryptionContext = NULL,
  authenticationType = NULL,
  clientToken = NULL,
  customerManagedKey = NULL,
  displayName = NULL,
  tags = NULL
)
}
\arguments{
\item{additionalEncryptionContext}{The additional encryption context of the portal.}

\item{authenticationType}{The type of authentication integration points used when signing into the
web portal. Defaults to \code{Standard}.

\code{Standard} web portals are authenticated directly through your identity
provider. You need to call
\code{\link[=workspacesweb_create_identity_provider]{create_identity_provider}} to
integrate your identity provider with your web portal. User and group
access to your web portal is controlled through your identity provider.

\code{IAM_Identity_Center} web portals are authenticated through AWS IAM
Identity Center (successor to AWS Single Sign-On). They provide
additional features, such as IdP-initiated authentication. Identity
sources (including external identity provider integration), plus user
and group access to your web portal, can be configured in the IAM
Identity Center.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Idempotency ensures that an API request
completes only once. With an idempotent request, if the original request
completes successfully, subsequent retries with the same client token
returns the result from the original successful request.

If you do not specify a client token, one is automatically generated by
the AWS SDK.}

\item{customerManagedKey}{The customer managed key of the web portal.}

\item{displayName}{The name of the web portal. This is not visible to users who log into
the web portal.}

\item{tags}{The tags to add to the web portal. A tag is a key-value pair.}
}
\description{
Creates a web portal.

See \url{https://www.paws-r-sdk.com/docs/workspacesweb_create_portal/} for full documentation.
}
\keyword{internal}
