# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Lookout for Equipment
#'
#' @description
#' Amazon Lookout for Equipment is a machine learning service that uses
#' advanced analytics to identify anomalies in machines from sensor data
#' for use in predictive maintenance.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- lookoutequipment(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- lookoutequipment()
#' # 
#' svc$create_retraining_scheduler(
#'   ClientToken = "sample-client-token",
#'   LookbackWindow = "P360D",
#'   ModelName = "sample-model",
#'   PromoteMode = "MANUAL",
#'   RetrainingFrequency = "P1M"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=lookoutequipment_create_dataset]{create_dataset} \tab Creates a container for a collection of data being ingested for analysis\cr
#'  \link[=lookoutequipment_create_inference_scheduler]{create_inference_scheduler} \tab Creates a scheduled inference\cr
#'  \link[=lookoutequipment_create_label]{create_label} \tab Creates a label for an event\cr
#'  \link[=lookoutequipment_create_label_group]{create_label_group} \tab Creates a group of labels\cr
#'  \link[=lookoutequipment_create_model]{create_model} \tab Creates a machine learning model for data inference\cr
#'  \link[=lookoutequipment_create_retraining_scheduler]{create_retraining_scheduler} \tab Creates a retraining scheduler on the specified model\cr
#'  \link[=lookoutequipment_delete_dataset]{delete_dataset} \tab Deletes a dataset and associated artifacts\cr
#'  \link[=lookoutequipment_delete_inference_scheduler]{delete_inference_scheduler} \tab Deletes an inference scheduler that has been set up\cr
#'  \link[=lookoutequipment_delete_label]{delete_label} \tab Deletes a label\cr
#'  \link[=lookoutequipment_delete_label_group]{delete_label_group} \tab Deletes a group of labels\cr
#'  \link[=lookoutequipment_delete_model]{delete_model} \tab Deletes a machine learning model currently available for Amazon Lookout for Equipment\cr
#'  \link[=lookoutequipment_delete_resource_policy]{delete_resource_policy} \tab Deletes the resource policy attached to the resource\cr
#'  \link[=lookoutequipment_delete_retraining_scheduler]{delete_retraining_scheduler} \tab Deletes a retraining scheduler from a model\cr
#'  \link[=lookoutequipment_describe_data_ingestion_job]{describe_data_ingestion_job} \tab Provides information on a specific data ingestion job such as creation time, dataset ARN, and status\cr
#'  \link[=lookoutequipment_describe_dataset]{describe_dataset} \tab Provides a JSON description of the data in each time series dataset, including names, column names, and data types\cr
#'  \link[=lookoutequipment_describe_inference_scheduler]{describe_inference_scheduler} \tab Specifies information about the inference scheduler being used, including name, model, status, and associated metadata\cr
#'  \link[=lookoutequipment_describe_label]{describe_label} \tab Returns the name of the label\cr
#'  \link[=lookoutequipment_describe_label_group]{describe_label_group} \tab Returns information about the label group\cr
#'  \link[=lookoutequipment_describe_model]{describe_model} \tab Provides a JSON containing the overall information about a specific machine learning model, including model name and ARN, dataset, training and evaluation information, status, and so on\cr
#'  \link[=lookoutequipment_describe_model_version]{describe_model_version} \tab Retrieves information about a specific machine learning model version\cr
#'  \link[=lookoutequipment_describe_resource_policy]{describe_resource_policy} \tab Provides the details of a resource policy attached to a resource\cr
#'  \link[=lookoutequipment_describe_retraining_scheduler]{describe_retraining_scheduler} \tab Provides a description of the retraining scheduler, including information such as the model name and retraining parameters\cr
#'  \link[=lookoutequipment_import_dataset]{import_dataset} \tab Imports a dataset\cr
#'  \link[=lookoutequipment_import_model_version]{import_model_version} \tab Imports a model that has been trained successfully\cr
#'  \link[=lookoutequipment_list_data_ingestion_jobs]{list_data_ingestion_jobs} \tab Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data, status, and so on\cr
#'  \link[=lookoutequipment_list_datasets]{list_datasets} \tab Lists all datasets currently available in your account, filtering on the dataset name\cr
#'  \link[=lookoutequipment_list_inference_events]{list_inference_events} \tab Lists all inference events that have been found for the specified inference scheduler\cr
#'  \link[=lookoutequipment_list_inference_executions]{list_inference_executions} \tab Lists all inference executions that have been performed by the specified inference scheduler\cr
#'  \link[=lookoutequipment_list_inference_schedulers]{list_inference_schedulers} \tab Retrieves a list of all inference schedulers currently available for your account\cr
#'  \link[=lookoutequipment_list_label_groups]{list_label_groups} \tab Returns a list of the label groups\cr
#'  \link[=lookoutequipment_list_labels]{list_labels} \tab Provides a list of labels\cr
#'  \link[=lookoutequipment_list_models]{list_models} \tab Generates a list of all models in the account, including model name and ARN, dataset, and status\cr
#'  \link[=lookoutequipment_list_model_versions]{list_model_versions} \tab Generates a list of all model versions for a given model, including the model version, model version ARN, and status\cr
#'  \link[=lookoutequipment_list_retraining_schedulers]{list_retraining_schedulers} \tab Lists all retraining schedulers in your account, filtering by model name prefix and status\cr
#'  \link[=lookoutequipment_list_sensor_statistics]{list_sensor_statistics} \tab Lists statistics about the data collected for each of the sensors that have been successfully ingested in the particular dataset\cr
#'  \link[=lookoutequipment_list_tags_for_resource]{list_tags_for_resource} \tab Lists all the tags for a specified resource, including key and value\cr
#'  \link[=lookoutequipment_put_resource_policy]{put_resource_policy} \tab Creates a resource control policy for a given resource\cr
#'  \link[=lookoutequipment_start_data_ingestion_job]{start_data_ingestion_job} \tab Starts a data ingestion job\cr
#'  \link[=lookoutequipment_start_inference_scheduler]{start_inference_scheduler} \tab Starts an inference scheduler\cr
#'  \link[=lookoutequipment_start_retraining_scheduler]{start_retraining_scheduler} \tab Starts a retraining scheduler\cr
#'  \link[=lookoutequipment_stop_inference_scheduler]{stop_inference_scheduler} \tab Stops an inference scheduler\cr
#'  \link[=lookoutequipment_stop_retraining_scheduler]{stop_retraining_scheduler} \tab Stops a retraining scheduler\cr
#'  \link[=lookoutequipment_tag_resource]{tag_resource} \tab Associates a given tag to a resource in your account\cr
#'  \link[=lookoutequipment_untag_resource]{untag_resource} \tab Removes a specific tag from a given resource\cr
#'  \link[=lookoutequipment_update_active_model_version]{update_active_model_version} \tab Sets the active model version for a given machine learning model\cr
#'  \link[=lookoutequipment_update_inference_scheduler]{update_inference_scheduler} \tab Updates an inference scheduler\cr
#'  \link[=lookoutequipment_update_label_group]{update_label_group} \tab Updates the label group\cr
#'  \link[=lookoutequipment_update_model]{update_model} \tab Updates a model in the account\cr
#'  \link[=lookoutequipment_update_retraining_scheduler]{update_retraining_scheduler} \tab Updates a retraining scheduler
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname lookoutequipment
#' @export
lookoutequipment <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .lookoutequipment$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.lookoutequipment <- list()

.lookoutequipment$operations <- list()

.lookoutequipment$metadata <- list(
  service_name = "lookoutequipment",
  endpoints = list("*" = list(endpoint = "lookoutequipment.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "lookoutequipment.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "lookoutequipment.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "lookoutequipment.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "lookoutequipment.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "lookoutequipment.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "LookoutEquipment",
  api_version = "2020-12-15",
  signing_name = "lookoutequipment",
  json_version = "1.0",
  target_prefix = "AWSLookoutEquipmentFrontendService"
)

.lookoutequipment$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.lookoutequipment$metadata, handlers, config, op)
}
