% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_create_model_version}
\alias{frauddetector_create_model_version}
\title{Creates a version of the model using the specified model type and model
id}
\usage{
frauddetector_create_model_version(
  modelId,
  modelType,
  trainingDataSource,
  trainingDataSchema,
  externalEventsDetail = NULL,
  ingestedEventsDetail = NULL,
  tags = NULL
)
}
\arguments{
\item{modelId}{[required] The model ID.}

\item{modelType}{[required] The model type.}

\item{trainingDataSource}{[required] The training data source location in Amazon S3.}

\item{trainingDataSchema}{[required] The training data schema.}

\item{externalEventsDetail}{Details of the external events data used for model version training.
Required if \code{trainingDataSource} is \code{EXTERNAL_EVENTS}.}

\item{ingestedEventsDetail}{Details of the ingested events data used for model version training.
Required if \code{trainingDataSource} is \code{INGESTED_EVENTS}.}

\item{tags}{A collection of key and value pairs.}
}
\description{
Creates a version of the model using the specified model type and model id.

See \url{https://www.paws-r-sdk.com/docs/frauddetector_create_model_version/} for full documentation.
}
\keyword{internal}
