% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_list_tags_for_resource}
\alias{cloudwatch_list_tags_for_resource}
\title{Displays the tags associated with a CloudWatch resource}
\usage{
cloudwatch_list_tags_for_resource(ResourceARN)
}
\arguments{
\item{ResourceARN}{[required] The ARN of the CloudWatch resource that you want to view tags for.

The ARN format of an alarm is
\code{arn:aws:cloudwatch:Region:account-id:alarm:alarm-name }

The ARN format of a Contributor Insights rule is
\code{arn:aws:cloudwatch:Region:account-id:insight-rule:insight-rule-name }

For more information about ARN format, see \href{https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies}{Resource Types Defined by Amazon CloudWatch}
in the \emph{Amazon Web Services General Reference}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}
\description{
Displays the tags associated with a CloudWatch resource. Currently,
alarms and Contributor Insights rules support tagging.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceARN = "string"
)
}
}

\keyword{internal}
