% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_aggregate_compliance_details_by_config_rule}
\alias{configservice_get_aggregate_compliance_details_by_config_rule}
\title{Returns the evaluation results for the specified AWS Config rule for a
specific resource in a rule}
\usage{
configservice_get_aggregate_compliance_details_by_config_rule(
  ConfigurationAggregatorName, ConfigRuleName, AccountId, AwsRegion,
  ComplianceType, Limit, NextToken)
}
\arguments{
\item{ConfigurationAggregatorName}{[required] The name of the configuration aggregator.}

\item{ConfigRuleName}{[required] The name of the AWS Config rule for which you want compliance
information.}

\item{AccountId}{[required] The 12-digit account ID of the source account.}

\item{AwsRegion}{[required] The source region from where the data is aggregated.}

\item{ComplianceType}{The resource compliance status.

For the \code{GetAggregateComplianceDetailsByConfigRuleRequest} data type,
AWS Config supports only the \code{COMPLIANT} and \code{NON_COMPLIANT}. AWS Config
does not support the \code{NOT_APPLICABLE} and \code{INSUFFICIENT_DATA} values.}

\item{Limit}{The maximum number of evaluation results returned on each page. The
default is 50. You cannot specify a number greater than 100. If you
specify 0, AWS Config uses the default.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\value{
A list with the following syntax:\preformatted{list(
  AggregateEvaluationResults = list(
    list(
      EvaluationResultIdentifier = list(
        EvaluationResultQualifier = list(
          ConfigRuleName = "string",
          ResourceType = "string",
          ResourceId = "string"
        ),
        OrderingTimestamp = as.POSIXct(
          "2015-01-01"
        )
      ),
      ComplianceType = "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA",
      ResultRecordedTime = as.POSIXct(
        "2015-01-01"
      ),
      ConfigRuleInvokedTime = as.POSIXct(
        "2015-01-01"
      ),
      Annotation = "string",
      AccountId = "string",
      AwsRegion = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns the evaluation results for the specified AWS Config rule for a
specific resource in a rule. The results indicate which AWS resources
were evaluated by the rule, when each resource was last evaluated, and
whether each resource complies with the rule.

The results can return an empty result page. But if you have a
\code{nextToken}, the results are displayed on the next page.
}
\section{Request syntax}{
\preformatted{svc$get_aggregate_compliance_details_by_config_rule(
  ConfigurationAggregatorName = "string",
  ConfigRuleName = "string",
  AccountId = "string",
  AwsRegion = "string",
  ComplianceType = "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA",
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
