% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_enable_policy_type}
\alias{organizations_enable_policy_type}
\title{Enables a policy type in a root}
\usage{
organizations_enable_policy_type(RootId, PolicyType)
}
\arguments{
\item{RootId}{[required] The unique identifier (ID) of the root in which you want to enable a
policy type. You can get the ID from the
\code{\link[=organizations_list_roots]{list_roots}} operation.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for a root ID
string requires "r-" followed by from 4 to 32 lowercase letters or
digits.}

\item{PolicyType}{[required] The policy type that you want to enable. You can specify one of the
following values:
\itemize{
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html}{AISERVICES_OPT_OUT_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html}{BACKUP_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html}{SERVICE_CONTROL_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html}{TAG_POLICY}
}}
}
\value{
A list with the following syntax:\preformatted{list(
  Root = list(
    Id = "string",
    Arn = "string",
    Name = "string",
    PolicyTypes = list(
      list(
        Type = "SERVICE_CONTROL_POLICY"|"TAG_POLICY"|"BACKUP_POLICY"|"AISERVICES_OPT_OUT_POLICY",
        Status = "ENABLED"|"PENDING_ENABLE"|"PENDING_DISABLE"
      )
    )
  )
)
}
}
\description{
Enables a policy type in a root. After you enable a policy type in a
root, you can attach policies of that type to the root, any
organizational unit (OU), or account in that root. You can undo this by
using the \code{\link[=organizations_disable_policy_type]{disable_policy_type}}
operation.

This is an asynchronous request that AWS performs in the background. AWS
recommends that you first use \code{\link[=organizations_list_roots]{list_roots}}
to see the status of policy types for a specified root, and then use
this operation.

This operation can be called only from the organization's management
account.

You can enable a policy type in a root only if that policy type is
available in the organization. To view the status of available policy
types in the organization, use
\code{\link[=organizations_describe_organization]{describe_organization}}.
}
\section{Request syntax}{
\preformatted{svc$enable_policy_type(
  RootId = "string",
  PolicyType = "SERVICE_CONTROL_POLICY"|"TAG_POLICY"|"BACKUP_POLICY"|"AISERVICES_OPT_OUT_POLICY"
)
}
}

\examples{
\dontrun{
# The following example shows how to enable the service control policy
# (SCP) policy type in a root. The output shows a root object with a
# PolicyTypes response element showing that SCPs are now enabled:/n/n
svc$enable_policy_type(
  PolicyType = "SERVICE_CONTROL_POLICY",
  RootId = "r-examplerootid111"
)
}

}
\keyword{internal}
