% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicequotas_operations.R
\name{servicequotas_request_service_quota_increase}
\alias{servicequotas_request_service_quota_increase}
\title{Submits a quota increase request for the specified quota}
\usage{
servicequotas_request_service_quota_increase(ServiceCode, QuotaCode,
  DesiredValue)
}
\arguments{
\item{ServiceCode}{[required] The service identifier.}

\item{QuotaCode}{[required] The quota identifier.}

\item{DesiredValue}{[required] The new, increased value for the quota.}
}
\value{
A list with the following syntax:\preformatted{list(
  RequestedQuota = list(
    Id = "string",
    CaseId = "string",
    ServiceCode = "string",
    ServiceName = "string",
    QuotaCode = "string",
    QuotaName = "string",
    DesiredValue = 123.0,
    Status = "PENDING"|"CASE_OPENED"|"APPROVED"|"DENIED"|"CASE_CLOSED",
    Created = as.POSIXct(
      "2015-01-01"
    ),
    LastUpdated = as.POSIXct(
      "2015-01-01"
    ),
    Requester = "string",
    QuotaArn = "string",
    GlobalQuota = TRUE|FALSE,
    Unit = "string"
  )
)
}
}
\description{
Submits a quota increase request for the specified quota.
}
\section{Request syntax}{
\preformatted{svc$request_service_quota_increase(
  ServiceCode = "string",
  QuotaCode = "string",
  DesiredValue = 123.0
)
}
}

\keyword{internal}
