% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_create_document}
\alias{ssm_create_document}
\title{Creates a Systems Manager (SSM) document}
\usage{
ssm_create_document(Content, Requires, Attachments, Name, VersionName,
  DocumentType, DocumentFormat, TargetType, Tags)
}
\arguments{
\item{Content}{[required] The content for the new SSM document in JSON or YAML format. We
recommend storing the contents for your new document in an external JSON
or YAML file and referencing the file in a command.

For examples, see the following topics in the \emph{AWS Systems Manager User
Guide}.
\itemize{
\item \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html}{Create an SSM document (AWS API)}
\item \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html}{Create an SSM document (AWS CLI)}
\item \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html}{Create an SSM document (API)}
}}

\item{Requires}{A list of SSM documents required by a document. This parameter is used
exclusively by AWS AppConfig. When a user creates an AppConfig
configuration in an SSM document, the user must also specify a required
document for validation purposes. In this case, an
\code{ApplicationConfiguration} document requires an
\code{ApplicationConfigurationSchema} document for validation purposes. For
more information, see \href{https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html}{AWS AppConfig}
in the \emph{AWS Systems Manager User Guide}.}

\item{Attachments}{A list of key and value pairs that describe attachments to a version of
a document.}

\item{Name}{[required] A name for the Systems Manager document.

You can't use the following strings as document name prefixes. These are
reserved by AWS for use as document name prefixes:
\itemize{
\item \verb{aws-}
\item \code{amazon}
\item \code{amzn}
}}

\item{VersionName}{An optional field specifying the version of the artifact you are
creating with the document. For example, "Release 12, Update 6". This
value is unique across all versions of a document, and cannot be
changed.}

\item{DocumentType}{The type of document to create.}

\item{DocumentFormat}{Specify the document format for the request. The document format can be
JSON, YAML, or TEXT. JSON is the default format.}

\item{TargetType}{Specify a target type to define the kinds of resources the document can
run on. For example, to run a document on EC2 instances, specify the
following value: /AWS::EC2::Instance. If you specify a value of '/' the
document can run on all types of resources. If you don't specify a
value, the document can't run on any resources. For a list of valid
resource types, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html}{AWS resource and property types reference}
in the \emph{AWS CloudFormation User Guide}.}

\item{Tags}{Optional metadata that you assign to a resource. Tags enable you to
categorize a resource in different ways, such as by purpose, owner, or
environment. For example, you might want to tag an SSM document to
identify the types of targets or the environment where it will run. In
this case, you could specify the following key name/value pairs:
\itemize{
\item \verb{Key=OS,Value=Windows}
\item \verb{Key=Environment,Value=Production}
}

To add tags to an existing SSM document, use the
\code{\link[=ssm_add_tags_to_resource]{add_tags_to_resource}} action.}
}
\value{
A list with the following syntax:\preformatted{list(
  DocumentDescription = list(
    Sha1 = "string",
    Hash = "string",
    HashType = "Sha256"|"Sha1",
    Name = "string",
    VersionName = "string",
    Owner = "string",
    CreatedDate = as.POSIXct(
      "2015-01-01"
    ),
    Status = "Creating"|"Active"|"Updating"|"Deleting"|"Failed",
    StatusInformation = "string",
    DocumentVersion = "string",
    Description = "string",
    Parameters = list(
      list(
        Name = "string",
        Type = "String"|"StringList",
        Description = "string",
        DefaultValue = "string"
      )
    ),
    PlatformTypes = list(
      "Windows"|"Linux"
    ),
    DocumentType = "Command"|"Policy"|"Automation"|"Session"|"Package"|"ApplicationConfiguration"|"ApplicationConfigurationSchema"|"DeploymentStrategy"|"ChangeCalendar"|"Automation.ChangeTemplate",
    SchemaVersion = "string",
    LatestVersion = "string",
    DefaultVersion = "string",
    DocumentFormat = "YAML"|"JSON"|"TEXT",
    TargetType = "string",
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    AttachmentsInformation = list(
      list(
        Name = "string"
      )
    ),
    Requires = list(
      list(
        Name = "string",
        Version = "string"
      )
    ),
    Author = "string",
    ReviewInformation = list(
      list(
        ReviewedTime = as.POSIXct(
          "2015-01-01"
        ),
        Status = "APPROVED"|"NOT_REVIEWED"|"PENDING"|"REJECTED",
        Reviewer = "string"
      )
    ),
    ApprovedVersion = "string",
    PendingReviewVersion = "string",
    ReviewStatus = "APPROVED"|"NOT_REVIEWED"|"PENDING"|"REJECTED"
  )
)
}
}
\description{
Creates a Systems Manager (SSM) document. An SSM document defines the
actions that Systems Manager performs on your managed instances. For
more information about SSM documents, including information about
supported schemas, features, and syntax, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html}{AWS Systems Manager Documents}
in the \emph{AWS Systems Manager User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_document(
  Content = "string",
  Requires = list(
    list(
      Name = "string",
      Version = "string"
    )
  ),
  Attachments = list(
    list(
      Key = "SourceUrl"|"S3FileUrl"|"AttachmentReference",
      Values = list(
        "string"
      ),
      Name = "string"
    )
  ),
  Name = "string",
  VersionName = "string",
  DocumentType = "Command"|"Policy"|"Automation"|"Session"|"Package"|"ApplicationConfiguration"|"ApplicationConfigurationSchema"|"DeploymentStrategy"|"ChangeCalendar"|"Automation.ChangeTemplate",
  DocumentFormat = "YAML"|"JSON"|"TEXT",
  TargetType = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
