% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_delete_document}
\alias{ssm_delete_document}
\title{Deletes the Systems Manager document and all instance associations to
the document}
\usage{
ssm_delete_document(Name, DocumentVersion, VersionName, Force)
}
\arguments{
\item{Name}{[required] The name of the document.}

\item{DocumentVersion}{The version of the document that you want to delete. If not provided,
all versions of the document are deleted.}

\item{VersionName}{The version name of the document that you want to delete. If not
provided, all versions of the document are deleted.}

\item{Force}{Some SSM document types require that you specify a \code{Force} flag before
you can delete the document. For example, you must specify a \code{Force}
flag to delete a document of type \code{ApplicationConfigurationSchema}. You
can restrict access to the \code{Force} flag in an AWS Identity and Access
Management (IAM) policy.}
}
\value{
An empty list.
}
\description{
Deletes the Systems Manager document and all instance associations to
the document.

Before you delete the document, we recommend that you use
\code{\link[=ssm_delete_association]{delete_association}} to disassociate all
instances that are associated with the document.
}
\section{Request syntax}{
\preformatted{svc$delete_document(
  Name = "string",
  DocumentVersion = "string",
  VersionName = "string",
  Force = TRUE|FALSE
)
}
}

\keyword{internal}
