% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_association_executions}
\alias{ssm_describe_association_executions}
\title{Use this API action to view all executions for a specific association ID}
\usage{
ssm_describe_association_executions(AssociationId, Filters, MaxResults,
  NextToken)
}
\arguments{
\item{AssociationId}{[required] The association ID for which you want to view execution history details.}

\item{Filters}{Filters for the request. You can specify the following filters and
values.

ExecutionId (EQUAL)

Status (EQUAL)

CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{A token to start the list. Use this token to get the next set of
results.}
}
\value{
A list with the following syntax:\preformatted{list(
  AssociationExecutions = list(
    list(
      AssociationId = "string",
      AssociationVersion = "string",
      ExecutionId = "string",
      Status = "string",
      DetailedStatus = "string",
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      LastExecutionDate = as.POSIXct(
        "2015-01-01"
      ),
      ResourceCountByStatus = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Use this API action to view all executions for a specific association
ID.
}
\section{Request syntax}{
\preformatted{svc$describe_association_executions(
  AssociationId = "string",
  Filters = list(
    list(
      Key = "ExecutionId"|"Status"|"CreatedTime",
      Value = "string",
      Type = "EQUAL"|"LESS_THAN"|"GREATER_THAN"
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
