% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_list_document_versions}
\alias{ssm_list_document_versions}
\title{List all versions for a document}
\usage{
ssm_list_document_versions(Name, MaxResults, NextToken)
}
\arguments{
\item{Name}{[required] The name of the document. You can specify an Amazon Resource Name (ARN).}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}
}
\value{
A list with the following syntax:\preformatted{list(
  DocumentVersions = list(
    list(
      Name = "string",
      DocumentVersion = "string",
      VersionName = "string",
      CreatedDate = as.POSIXct(
        "2015-01-01"
      ),
      IsDefaultVersion = TRUE|FALSE,
      DocumentFormat = "YAML"|"JSON"|"TEXT",
      Status = "Creating"|"Active"|"Updating"|"Deleting"|"Failed",
      StatusInformation = "string",
      ReviewStatus = "APPROVED"|"NOT_REVIEWED"|"PENDING"|"REJECTED"
    )
  ),
  NextToken = "string"
)
}
}
\description{
List all versions for a document.
}
\section{Request syntax}{
\preformatted{svc$list_document_versions(
  Name = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
