% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perumammals_api.R
\name{match_quality_peru}
\alias{match_quality_peru}
\title{Get match quality for Peru mammal names}
\usage{
match_quality_peru(splist, return_details = FALSE)
}
\arguments{
\item{splist}{Character vector of species names}

\item{return_details}{Logical. If TRUE, includes distance metrics and
matching information (default: FALSE)}
}
\value{
If return_details = FALSE: Character vector with match quality
If return_details = TRUE: Tibble with detailed matching information
}
\description{
Returns the quality of taxonomic name matching (exact vs fuzzy) for
species validated against the Peru mammals database.
}
\details{
Match quality categories:
\itemize{
\item "Exact": Perfect match with no spelling differences (genus_dist = 0, species_dist = 0)
\item "Fuzzy": Match found with minor spelling variations (genus_dist > 0 or species_dist > 0)
\item "Not found": No match in database
}

The function uses string distance metrics to quantify matching quality:
\itemize{
\item genus_dist: Edit distance for genus name
\item species_dist: Edit distance for species epithet
}
}
\examples{

species <- c(
  "Panthera onca",      # Exact
  "Tremarctos orrnatus", # Fuzzy (spelling error)
  "Felis domesticus",   # Not found
  "Myotis bakeri"
)

# Simple quality check
match_quality_peru(species)

# Detailed information with edit distances
details <- match_quality_peru(species, return_details = TRUE)
details



}
