% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcFUN.R
\name{qc_sentinel2}
\alias{qc_sentinel2}
\title{Initial weights for sentinel2 according to SCL band}
\usage{
qc_sentinel2(SCL, wmin = 0.2, wmid = 0.5, wmax = 1)
}
\arguments{
\item{SCL}{quality control variable for sentinel2}

\item{wmin}{Double, minimum weigth (i.e. weight of snow, ice and cloud).}

\item{wmid}{Dougle, middle weight, i.e. marginal}

\item{wmax}{Double, maximum weight, i.e. good}
}
\description{
\tabular{llll}{
   \strong{SCL Value} \tab \strong{Description} \tab \strong{Quality} \tab \strong{weight} \cr
   1 \tab Saturated or defective \tab Bad \tab \eqn{w_{min}} \cr
   2 \tab Dark Area Pixels \tab Bad \tab \eqn{w_{min}} \cr
   3 \tab Cloud Shadows \tab Bad \tab \eqn{w_{min}} \cr
   4 \tab Vegetation \tab Good \tab \eqn{w_{max}} \cr
   5 \tab Bare Soils \tab Good \tab \eqn{w_{max}} \cr
   6 \tab Water \tab Good \tab \eqn{w_{max}} \cr
   7 \tab Clouds Low Probability / Unclassified \tab Good \tab \eqn{w_{max}} \cr
   8 \tab Clouds Medium Probability \tab Marginal \tab \eqn{w_{mid}} \cr
   9 \tab Clouds High Probability \tab Bad \tab \eqn{w_{mid}} \cr
   10 \tab Cirrus \tab Good \tab \eqn{w_{mid}} \cr
   11 \tab Snow / Ice \tab Bad \tab \eqn{w_{mid}} \cr
}
}
\examples{
qc_sentinel2(1:11)
}
\references{
https://developers.google.com/earth-engine/datasets/catalog/COPERNICUS_S2_SR
}
