% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce-aggregation_structure.R
\name{as.matrix.piar_aggregation_structure}
\alias{as.matrix.piar_aggregation_structure}
\alias{as.data.frame.piar_aggregation_structure}
\title{Coerce an aggregation structure into a tabular form}
\usage{
\method{as.matrix}{piar_aggregation_structure}(x, ..., sparse = FALSE)

\method{as.data.frame}{piar_aggregation_structure}(x, ..., stringsAsFactors = FALSE)
}
\arguments{
\item{x}{A price index aggregation structure, as made by
\code{\link[=aggregation_structure]{aggregation_structure()}}.}

\item{...}{Not currently used.}

\item{sparse}{Should the result be a sparse matrix from \pkg{Matrix}? This
is faster for large aggregation structures. The default returns an ordinary
dense matrix.}

\item{stringsAsFactors}{See \code{\link[=as.data.frame]{as.data.frame()}}.}
}
\value{
\code{as.matrix()} represents an aggregation structure as a matrix,
such that multiplying with a (column) vector of elemental indexes gives the
aggregated index.

\code{as.data.frame()} takes an aggregation structure and returns a data
frame that could have generated it, with columns \code{level1},
\code{level2}, ..., \code{ea}, and \code{weight}.
}
\description{
Coerce a price index aggregation structure into an aggregation matrix, or a
data frame.
}
\examples{
# A simple aggregation structure
#            1
#      |-----+-----|
#      11          12
#  |---+---|       |
#  111     112     121
#  (1)     (3)     (4)

aggregation_weights <- data.frame(
  level1 = c("1", "1", "1"),
  level2 = c("11", "11", "12"),
  ea     = c("111", "112", "121"),
  weight = c(1, 3, 4)
)

pias <- as_aggregation_structure(aggregation_weights)

as.matrix(pias)

all.equal(as.data.frame(pias), aggregation_weights)

}
\seealso{
\code{\link[=as_aggregation_structure]{as_aggregation_structure()}} for coercing into an aggregation structure.

Other aggregation structure methods: 
\code{\link{levels.piar_aggregation_structure}()},
\code{\link{update.piar_aggregation_structure}()},
\code{\link{weights.piar_aggregation_structure}()}
}
\concept{aggregation structure methods}
