% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqData_wrappers.R
\name{edgeR_wrapper}
\alias{edgeR_wrapper}
\title{Wrapper for edgeR workflow}
\usage{
edgeR_wrapper(
  omicsData,
  p_adjust = "BH",
  comparisons = NULL,
  p_cutoff = 0.05,
  ...
)
}
\arguments{
\item{omicsData}{an object of type 'seqData', created by
\code{\link{as.seqData}}}

\item{p_adjust}{Character string for p-value correction method, refer to
?p.adjust() for valid options. Defaults to "BH" (Benjamini & Hochberg).}

\item{comparisons}{`data.frame` with columns for "Control" and "Test"
containing the different comparisons of interest. Comparisons will be made
between the Test and the corresponding Control  If left NULL, then all
pairwise comparisons are executed.}

\item{p_cutoff}{Numeric value between 0 and 1 for setting p-value
significance threshold}

\item{...}{additional arguments passed to methods functions. Note, formatting
option changes will interfere with wrapping functionality.}
}
\value{
statRes object
}
\description{
For generating statistics for 'seqData' objects.
}
\details{
Requires the 'edgeR' and 'limma' packages. Runs default edgeR workflow with 
  empirical Bayes quasi-likelihood F-tests. Additional arguments can be
  passed for use in the function, refer to calcNormFactors() and glmQLFit()
  in edgeR package.

Flags (signatures) -	Indicator of statistical significance for computed test.
Zeroes indicate no significance, while +/- 1 indicates direction of significance.
}
\references{
Robinson MD, McCarthy DJ, Smyth GK (2010). “edgeR: a Bioconductor package
 for differential expression analysis of digital gene expression data.”
 Bioinformatics, 26(1), 139-140. doi: 10.1093/bioinformatics/btp616.
}
